// Copyright (c) 2022 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _RSI_STATS_WND_H_
#define _RSI_STATS_WND_H_

#include "RSI/definitions.h"
#include "RSI/preferences.h"
#include "RSI/app_info.h"
#include "RSI/stats.h"

#include "WDL/wingui/wndsize.h"
#include "WDL/ptrlist.h"
#include "WDL/wdlstring.h"
#include "WDL/lice/lice.h"
#include "WDL/lice/lice_text.h"
#include "WDL/wingui/virtwnd.h"
#include "WDL/wingui/virtwnd-controls.h"
#include "WDL/wingui/wndsize.h"

class RSI_Stats;

class RSI_StatsWnd
{
public:
  RSI_StatsWnd()
    : m_hwnd(NULL)
    , m_bm(NULL)
    , m_font(NULL)
  {
    m_bgc = g_preferences->GetBackgroundColor();
    m_txtc = g_preferences->GetTextColor();
  }

  ~RSI_StatsWnd()
  {
    DestroyWindow(m_hwnd);
    //delete m_bm;
    delete m_font;
  }

  HWND Handle() const { return m_hwnd; }
  static WDL_DLGRET StatsWndProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam);
private:
  void OnInitDialog();
  void OnDestroy();
  void OnPaint();
  void OnLButtonUp();
  void OnSize();
  void OnTimer();
  void OnCommand();
  WDL_DLGRET StatsWndLoop(UINT msg, WPARAM wparam, LPARAM lparam);

  HWND m_hwnd;
  UINT m_msg;
  WPARAM m_wparam;
  LPARAM m_lparam;
  WDL_VWnd_Painter m_painter;
  LICE_IBitmap *m_bm;
  LICE_IFont *m_font;
  int m_bgc, m_txtc;
  RSI_Stats m_stats;
  WDL_FastString m_strbuf;
  WDL_WndSizer m_resize;
  WDL_VirtualStaticText m_dis;
};

#endif // _RSI_STATS_WND_H_
