// Copyright (c) 2021 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _RSI_TRACK_H_
#define _RSI_TRACK_H_

#include "RSI/definitions.h"
#include "RSI/buffer_queue.h"
#include "RSI/preferences.h"
#include "RSI/plugin.h"

#include "WDL/mutex.h"
#include "WDL/ptrlist.h"
#include "WDL/wdlstring.h"

class RSI_Track
{
public:
  RSI_Track(int data_bank_slot, const char *filename, bool repeat);
  ~RSI_Track();

  void Pause();
  void Rewind(bool state);
  void FastForward(bool state);
  void Play(); void PlayReverse();
  void Stop();
  void StartStop(bool state);

  void Seek(double time);

  bool IsPaused() const;
  bool IsRewind() const;
  bool IsFastForward() const;
  bool IsActive() const;
  bool IsDrained() const;
  bool WantMore() const;
  bool DoBuffering(int buffer_size = 4096);
  bool DoBufferingReverse(int buffer_size = 4096);

  double GetTime() const;
  double GetTotalTime() const;

  void SetShift(double shift);
  void SetTempo(double tempo);
  double GetShift() const;
  double GetTempo() const;

  void ToggleRepeat();
  bool IsRepeat() const;
  void ToggleHeadphone();
  bool IsHeadphone() const;

  void ToggleReversePlayback();
  bool IsPlaybackReverse() const;

  void IncreaseVolume();
  void DecreaseVolume();
  double GetVolume() const;
  void SetVolume(double db);

  const char *GetArtist() const;
  const char *GetTitle() const;

  RSI_BufferQueue m_bq;

private:
  double m_srate;
  int m_bqms;
  bool m_eof;
  WDL_FastString m_fn;

  WDL_TypedBuf<SAM> m_buffer;
  bool m_active;

  double m_shift;
  double m_tempo;
  double m_lastshift;
  double m_lasttempo;

  RSI_IPitchShift *m_ps;

  bool m_repeat;
  bool m_pause;
  bool m_rwd;
  bool m_fwd;
  bool m_ss;

  bool m_lastpause;
  bool m_lastrev;
  double m_rwdfwdshift;
  double m_rwdfwdtempo;

  WDL_FastString m_artist;
  WDL_FastString m_title;

  double m_vol;
  double m_volstep;
  int m_databankslot;
  bool m_reverse;
  double m_startstop;
  bool m_headphone;
};

#endif // _RSI_TRACK_H_
