// Copyright (c) 2022 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _RSI_TRACK_WND_H_
#define _RSI_TRACK_WND_H_

#include "RSI/definitions.h"
#include "RSI/preferences.h"
#include "RSI/render_system.h"
#include "RSI/main_wnd.h"
#include "RSI/data_bank.h"
#include "RSI/app_info.h"
#include "RSI/plugin.h"

#include "WDL/wingui/wndsize.h"
#include "WDL/wdlstring.h"
#include "WDL/lice/lice.h"
#include "WDL/lice/lice_text.h"
#include "WDL/wingui/virtwnd.h"
#include "WDL/wingui/virtwnd-controls.h"
#include "WDL/fileread.h"

class RSI_TrackPauseButton : public WDL_VirtualIconButton
{
public:
  RSI_TrackPauseButton()
  {}
  ~RSI_TrackPauseButton()
  {}

  void OnMouseUp(int xpos, int ypos)
  {
    g_rendersystem->Pause();
    WDL_VirtualIconButton::OnMouseUp(xpos, ypos);
  }
};

class RSI_TrackRewindButton : public WDL_VirtualIconButton
{
public:
  RSI_TrackRewindButton()
  {}
  ~RSI_TrackRewindButton()
  {}

  int OnMouseDown(int xpos, int ypos)
  {
    g_rendersystem->Rewind(true);
    return WDL_VirtualIconButton::OnMouseDown(xpos, ypos);
  }

  void OnMouseUp(int xpos, int ypos)
  {
    g_rendersystem->Rewind(false);
    WDL_VirtualIconButton::OnMouseUp(xpos, ypos);
  }
};

class RSI_TrackFastForwardButton : public WDL_VirtualIconButton
{
public:
  RSI_TrackFastForwardButton()
  {}
  ~RSI_TrackFastForwardButton()
  {}

  int OnMouseDown(int xpos, int ypos)
  {
    g_rendersystem->FastForward(true);
    return WDL_VirtualIconButton::OnMouseDown(xpos, ypos);
  }

  void OnMouseUp(int xpos, int ypos)
  {
    g_rendersystem->FastForward(false);
    WDL_VirtualIconButton::OnMouseUp(xpos, ypos);
  }
};

class RSI_TrackPlayButton : public WDL_VirtualIconButton
{
public:
  RSI_TrackPlayButton()
  {}
  ~RSI_TrackPlayButton()
  {}

  void OnMouseUp(int xpos, int ypos)
  {
    g_rendersystem->Play();
    WDL_VirtualIconButton::OnMouseUp(xpos, ypos);
  }
};

class RSI_TrackStopButton : public WDL_VirtualIconButton
{
public:
  RSI_TrackStopButton()
  {}
  ~RSI_TrackStopButton()
  {}

  void OnMouseUp(int xpos, int ypos)
  {
    g_rendersystem->Stop();
    WDL_VirtualIconButton::OnMouseUp(xpos, ypos);
  }
};

class RSI_TrackLoadButton : public WDL_VirtualIconButton
{
public:
  RSI_TrackLoadButton()
  {}
  ~RSI_TrackLoadButton()
  {}

  void OnMouseUp(int xpos, int ypos)
  {
    SendMessage(g_mainwnd->Handle(), WM_COMMAND, ID_FILE_LOADTRACK, 0);
    WDL_VirtualIconButton::OnMouseUp(xpos, ypos);
  }
};

class RSI_EBUR128Button : public WDL_VirtualStaticText
{
public:
  RSI_EBUR128Button()
  {}
  ~RSI_EBUR128Button()
  {}

  bool OnMouseDblClick(int xpos, int ypos)
  {
    WDL_FastString ss;
    int at = g_rendersystem->GetActiveTrack();
    ss.SetFormatted(128, "EBU R128 details (F%d)", at);
    MessageBox(g_mainwnd->Handle(), GetText(), ss.Get(), MB_OK);
    return WDL_VirtualStaticText::OnMouseDblClick(xpos, ypos);
  }
};

class RSI_TrackWnd
{
public:
  RSI_TrackWnd();
  ~RSI_TrackWnd();

  HWND Handle() const { return m_hwnd; }
  void UpdateScreenRegions();
  static WDL_DLGRET TrackWndProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam);
private:
  void OnInitDialog();
  void OnDestroy();
  void OnPaint();
  void OnLButtonDown();
  void OnLButtonUp();
  void OnLButtonDblClk();
  void OnMouseMove();
  void OnSize();
  void OnTimer();
  void OnContextMenu();
  void OnCommand();
  WDL_DLGRET TrackWndLoop(UINT msg, WPARAM wparam, LPARAM lparam);

  enum
  {
    TRK_LABEL,
    TRK_TITLE,
    TRK_ARTIST,
    TRK_TIME,
    TRK_INFO,
    TRK_EBUR128,
    TRK_PAUSE,
    TRK_REWIND,
    TRK_FASTFORWARD,
    TRK_PLAY,
    TRK_STOP,
    TRK_LOAD
  };

  HWND m_hwnd;
  UINT m_msg;
  WPARAM m_wparam;
  LPARAM m_lparam;
  WDL_VirtualWnd_Painter m_painter;
  LICE_IBitmap *m_bm;
  LICE_IFont *m_font;
  LICE_IFont *m_bigfont;
  LICE_IFont *m_buttonfont;
  int m_bgc, m_txtc;
  WDL_WndSizer m_resize;
  int m_trkidx;
  int m_sltidx;
  WDL_FastString m_strbuf;
  WDL_VWnd m_vwnd;
  WDL_VirtualStaticText m_label;
  WDL_VirtualStaticText m_title;
  WDL_VirtualStaticText m_artist;
  WDL_VirtualStaticText m_time;
  RSI_TrackPauseButton m_pause;
  RSI_TrackRewindButton m_rewind;
  RSI_TrackFastForwardButton m_fastforward;
  RSI_TrackPlayButton m_play;
  RSI_TrackStopButton m_stop;
  RSI_TrackLoadButton m_load;
  WDL_VirtualStaticText m_info;
  RSI_EBUR128Button m_ebur128;
  HWND m_wfa;
  HWND m_wfb;
  HMENU m_contextmenu;
};

#endif // _RSI_TRACK_WND_H_
