rem Retrieve major/minor version
rem ============================

setlocal enabledelayedexpansion

for /f "delims=" %%a in ('findstr /b /c:"#define TERPSICHORE_MAJOR_VERSION " ..\..\src\terpsichore\app_info.h') do (
  set pwd=%%a
  set "pwd=!pwd:Password: =!"
)

set major_ver="%pwd%"
set maj=%major_ver:~35,1%

for /f "delims=" %%a in ('findstr /b /c:"#define TERPSICHORE_MINOR_VERSION " ..\..\src\terpsichore\app_info.h') do (
  set pwd=%%a
  set "pwd=!pwd:Password: =!"
)

set minor_ver="%pwd%"
set min=%minor_ver:~35,2%

for /f "delims=" %%a in ('findstr /b /c:"#define TERPSICHORE_RELEASE " ..\..\src\terpsichore\app_info.h') do (
  set pwd=%%a
  set "pwd=!pwd:Password: =!"
)

set release="%pwd%"
set rel=%release:~30%

rmdir /s /q build
rmdir /s /q src
del /s /q terpsichore-st*.zip

mkdir build
mkdir build\vc
mkdir build\linux
mkdir src
mkdir src\WDL-GV
mkdir src\terpsichore
mkdir src\terpsichore_st

xcopy /y /s ..\..\src\WDL-GV src\WDL-GV
xcopy /y ..\..\src\terpsichore\terpsichore_plugin_public.h src\terpsichore
xcopy /y ..\..\src\terpsichore\sample_format.h src\terpsichore
xcopy /y ..\..\build\vc\terpsichore-st.* build\vc
xcopy /y ..\..\build\linux\makefile_terpsichore_st.mk build\linux
xcopy /y ..\..\build\linux\Makefile build\linux
xcopy /y /s ..\..\src\terpsichore_st src\terpsichore_st

7z a -tzip -mx=1 terpsichore-st-%maj%.%min%%rel%-src.zip build
7z a -tzip -mx=1 terpsichore-st-%maj%.%min%%rel%-src.zip src
7z a -tzip -mx=1 terpsichore-st-%maj%.%min%%rel%-src.zip README.txt
7z d -r terpsichore-st-%maj%.%min%%rel%-src.zip build\vc\Win32
7z d -r terpsichore-st-%maj%.%min%%rel%-src.zip build\vc\x64
7z d -r terpsichore-st-%maj%.%min%%rel%-src.zip *.o
7z t terpsichore-st-%maj%.%min%%rel%-src.zip * -r

rmdir /s /q build
rmdir /s /q src

pause
