rem Clean-up
rem ========

rem del *.zip
rem del *.exe
rem del changelog.txt

copy ..\doc\changelog.txt .\

rem Terpsichore x86 (installer)
rem =======================

makensis terpsichore_x86.nsi

rem Terpsichore x64 (installer)
rem =======================

makensis terpsichore_x64.nsi

rem Retrieve major/minor version
rem ============================

setlocal enabledelayedexpansion

for /f "delims=" %%a in ('findstr /b /c:"#define TERPSICHORE_MAJOR_VERSION " ..\src\terpsichore\app_info.h') do (
  set pwd=%%a
  set "pwd=!pwd:Password: =!"
)

set major_ver="%pwd%"
set maj=%major_ver:~35,1%

for /f "delims=" %%a in ('findstr /b /c:"#define TERPSICHORE_MINOR_VERSION " ..\src\terpsichore\app_info.h') do (
  set pwd=%%a
  set "pwd=!pwd:Password: =!"
)

set minor_ver="%pwd%"
set min=%minor_ver:~35,2%

for /f "delims=" %%a in ('findstr /b /c:"#define TERPSICHORE_RELEASE " ..\src\terpsichore\app_info.h') do (
  set pwd=%%a
  set "pwd=!pwd:Password: =!"
)

set release="%pwd%"
set rel=%release:~30%

rem Terpsichore x86 (portable)
rem ======================

rem Note: -mx=1 (fastest), -mx=3 (fast), nothing or -mx=5 (normal)

7z a -tzip -mx=1 terpsichore-%maj%.%min%%rel%-x86.zip ..\build\vc\Win32\Release\terpsichore.exe
7z a -tzip -mx=1 terpsichore-%maj%.%min%%rel%-x86.zip ..\build\vc\Win32\Release\plugins\
7z a -tzip -mx=1 terpsichore-%maj%.%min%%rel%-x86.zip ..\build\vc\Win32\Release\*.dll
7z a -tzip -mx=1 terpsichore-%maj%.%min%%rel%-x86.zip ..\build\vc\Win32\Release\changelog.txt
7z a -tzip -mx=1 terpsichore-%maj%.%min%%rel%-x86.zip ..\build\vc\Win32\Release\license.txt
7z a -tzip -mx=1 terpsichore-%maj%.%min%%rel%-x86.zip ..\build\vc\Win32\Release\documentation.txt
7z a -tzip -mx=1 terpsichore-%maj%.%min%%rel%-x86.zip ..\build\vc\Win32\Release\themes
7z a -tzip -mx=1 terpsichore-%maj%.%min%%rel%-x86.zip portable
7z d -r terpsichore-%maj%.%min%%rel%-x86.zip *.lib
7z d -r terpsichore-%maj%.%min%%rel%-x86.zip *.pdb
7z d -r terpsichore-%maj%.%min%%rel%-x86.zip *.exp
7z t terpsichore-%maj%.%min%%rel%-x86.zip * -r

rem Terpsichore x64 (portable)
rem ======================

7z a -tzip -mx=1 terpsichore-%maj%.%min%%rel%-x64.zip ..\build\vc\x64\Release\terpsichore.exe
7z a -tzip -mx=1 terpsichore-%maj%.%min%%rel%-x64.zip ..\build\vc\x64\Release\plugins\
7z a -tzip -mx=1 terpsichore-%maj%.%min%%rel%-x64.zip ..\build\vc\x64\Release\*.dll
7z a -tzip -mx=1 terpsichore-%maj%.%min%%rel%-x64.zip ..\build\vc\x64\Release\changelog.txt
7z a -tzip -mx=1 terpsichore-%maj%.%min%%rel%-x64.zip ..\build\vc\x64\Release\license.txt
7z a -tzip -mx=1 terpsichore-%maj%.%min%%rel%-x64.zip ..\build\vc\x64\Release\documentation.txt
7z a -tzip -mx=1 terpsichore-%maj%.%min%%rel%-x64.zip ..\build\vc\x64\Release\themes
7z a -tzip -mx=1 terpsichore-%maj%.%min%%rel%-x64.zip portable
7z d -r terpsichore-%maj%.%min%%rel%-x64.zip *.lib
7z d -r terpsichore-%maj%.%min%%rel%-x64.zip *.pdb
7z d -r terpsichore-%maj%.%min%%rel%-x64.zip *.exp
7z t terpsichore-%maj%.%min%%rel%-x64.zip * -r

cd ..
git archive --format=zip --prefix=GV-945/ HEAD > pack\terpsichore-%maj%.%min%%rel%-src.zip
git archive --format=tar.gz --prefix=GV-945/ HEAD > pack\terpsichore-%maj%.%min%%rel%-src.tar.gz

pause
