!include "MUI2.nsh"
!include "LogicLib.nsh"

;Unicode true

;SetCompress off
SetCompressor zlib
;SetCompressor /solid LZMA
;SetCompressorDictSize 8
;RequestExecutionLevel highest
RequestExecutionLevel admin

;!define MUI_ICON "${NSISDIR}\Contrib\Graphics\Icons\nsis3-install-alt.ico"
;!define MUI_UNICON "${NSISDIR}\Contrib\Graphics\Icons\nsis3-uninstall.ico"
;!define MUI_WELCOMEFINISHPAGE_BITMAP "${NSISDIR}\Contrib\Graphics\Wizard\nsis3-metro.bmp"
!define MUI_ICON "${NSISDIR}\Contrib\Graphics\Icons\orange-install.ico"
!define MUI_UNICON "${NSISDIR}\Contrib\Graphics\Icons\orange-uninstall.ico"
!define MUI_WELCOMEFINISHPAGE_BITMAP "${NSISDIR}\Contrib\Graphics\Wizard\orange.bmp"
!define MUI_COMPONENTSPAGE_NODESC
!define MUI_FINISHPAGE_NOAUTOCLOSE

!searchparse /file ..\src\terpsichore\app_info.h '#define TERPSICHORE_MAJOR_VERSION ' MAJOR
!searchparse /file ..\src\terpsichore\app_info.h '#define TERPSICHORE_MINOR_VERSION ' MINOR
!searchparse /file ..\src\terpsichore\app_info.h '#define TERPSICHORE_RELEASE "' RELEASE '"'
!searchparse /file ..\src\terpsichore\app_info.h '#define TERPSICHORE_COPYRIGHT "' COPYRIGHT '"'
!searchparse /file ..\src\terpsichore\app_info.h '#define TERPSICHORE_COMPANY_URL "' COMPANY '"'

Name "Terpsichore"
OutFile "terpsichore-${MAJOR}.${MINOR}${RELEASE}-x64-install.exe"
;BrandingText "Grafmin"

VIAddVersionKey "ProductName" "Terpsichore"
VIAddVersionKey "CompanyName" "${COMPANY}"
VIAddVersionKey "FileDescription" "Terpsichore installer (x64)"
VIAddVersionKey "FileVersion" "${MAJOR}.${MINOR}.0.0"
VIAddVersionKey "ProductVersion" "${MAJOR}.${MINOR}"
VIAddVersionKey "LegalCopyright" "${COPYRIGHT}"
VIProductVersion "${MAJOR}.${MINOR}.0.0"

InstallDir "$PROGRAMFILES64\Terpsichore"

;Get installation folder from registry if available
InstallDirRegKey HKCU "Software\Terpsichore (x64)" ""

!define MUI_ABORTWARNING
!define MUI_FINISHPAGE_RUN $INSTDIR\terpsichore.exe

!insertmacro MUI_PAGE_LICENSE "..\doc\license.txt"
!insertmacro MUI_PAGE_COMPONENTS
!insertmacro MUI_PAGE_DIRECTORY
!insertmacro MUI_PAGE_INSTFILES
!insertmacro MUI_PAGE_FINISH
;AutoCloseWindow true

!insertmacro MUI_UNPAGE_CONFIRM
!insertmacro MUI_UNPAGE_INSTFILES

!insertmacro MUI_LANGUAGE "English"

Section "Terpsichore" SecTerpsichore
  SectionIn RO

  SetOutPath "$INSTDIR"

  File "..\build\vc\x64\Release\terpsichore.exe"
  File "..\build\vc\x64\Release\*.dll"
  File "..\build\vc\x64\Release\changelog.txt"
  File "..\build\vc\x64\Release\license.txt"
  File "..\build\vc\Win32\Release\documentation.txt"

  SetOutPath "$INSTDIR\plugins"
  File /r "..\build\vc\x64\Release\plugins\*.dll"

  ;SetOutPath "$INSTDIR\themes"
  ;File /r "..\build\vc\x64\Release\themes\*.*"

  ;Store installation folder
  WriteRegStr HKCU "Software\Terpsichore (x64)" "" $INSTDIR

  ;Create uninstaller
  WriteUninstaller "$INSTDIR\uninstall.exe"
SectionEnd

Section "Start menu shortcuts" SecStart
  SetOutPath "$SMPROGRAMS\Terpsichore (x64)"
  CreateShortcut "$OUTDIR\Terpsichore (x64).lnk" "$INSTDIR\terpsichore.exe"
  CreateShortcut "$OUTDIR\Uninstall Terpsichore (x64).lnk" "$INSTDIR\uninstall.exe"
SectionEnd

Section /o "Desktop icon" SecDesktop
  SetOutPath $DESKTOP
  CreateShortcut "$OUTDIR\Terpsichore (x64).lnk" "$INSTDIR\terpsichore.exe"
SectionEnd

;Language strings
LangString DESC_SecTerpsichore ${LANG_ENGLISH} "Terpsichore core (required)."
LangString DESC_SecStart ${LANG_ENGLISH} "Start menu shortcuts."
LangString DESC_SecDesktop ${LANG_ENGLISH} "Desktop icon."

;Assign language strings to sections
!insertmacro MUI_FUNCTION_DESCRIPTION_BEGIN
!insertmacro MUI_DESCRIPTION_TEXT ${SecTerpsichore} $(DESC_SecTerpsichore)
!insertmacro MUI_DESCRIPTION_TEXT ${SecStart} $(DESC_SecStart)
!insertmacro MUI_DESCRIPTION_TEXT ${SecDesktop} $(DESC_SecDesktop)
!insertmacro MUI_FUNCTION_DESCRIPTION_END

;--------------------------------
;Uninstaller Section

Section "Uninstall"
  StrCpy $1 "terpsichore.exe"

retry:
  nsProcess::_FindProcess "$1"

  Pop $R0
  ${if} $R0 = 0
    MessageBox MB_RETRYCANCEL "Terpsichore is running. Close Terpsichore and hit Retry." /SD IDRETRY IDCANCEL cancel
    Goto retry
  ${endif}

  Delete "$DESKTOP\Terpsichore (x64).lnk"
  Delete "$SMPROGRAMS\Terpsichore (x64)\Terpsichore (x64).lnk"
  Delete "$SMPROGRAMS\Terpsichore (x64)\Uninstall Terpsichore (x64).lnk"
  RMDir /r "$SMPROGRAMS\Terpsichore (x64)"

  Delete "$INSTDIR\terpsichore.exe"
  Delete "$INSTDIR\*.dll"
  Delete "$INSTDIR\changelog.txt"
  Delete "$INSTDIR\license.txt"
  Delete "$INSTDIR\documentation.txt"
  RMDir /r "$INSTDIR\plugins"
  ;RMDir /r "$INSTDIR\themes"
  Delete "$INSTDIR\uninstall.exe"
  RMDir "$INSTDIR"

  DeleteRegKey /ifempty HKCU "Software\Terpsichore (x64)"

  Goto cont

cancel:
  Abort

cont:
SectionEnd
