// Copyright (c) 2019 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _TERPSICHORE_ABOUT_WINDOW_H_
#define _TERPSICHORE_ABOUT_WINDOW_H_

#include "terpsichore/definitions.h"

#include "WDL/wingui/wndsize.h"
#include "WDL/lice/lice.h"
#include "WDL/lice/lice_text.h"
#include "WDL/mutex.h"

class RST_AboutWnd
{
public:
  RST_AboutWnd();
  ~RST_AboutWnd();

  HWND Handle() const;

  static WDL_DLGRET ST_AboutWndProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam);

private:
  WDL_DLGRET AboutWndProc(UINT msg, WPARAM wparam, LPARAM lparam);
  void DoPaint(HWND hwnd, HDC dc);
  static unsigned int WINAPI ThreadFunction(void *arg);
  int Run();
  void OnInitDialog(WPARAM wparam, LPARAM lparam);
  void OnPaint(WPARAM wparam, LPARAM lparam);
  void OnTimer(WPARAM wparam, LPARAM lparam);
  void OnSize(WPARAM wparam, LPARAM lparam);
  void OnDestroy(WPARAM wparam, LPARAM lparam);
  void OnCommand(WPARAM wparam, LPARAM lparam);

  HWND m_hwnd;
  RST_MainWnd *m_par;
  int m_x, m_y, m_w, m_h;

  WDL_WndSizer m_resize;
  LICE_IBitmap *m_bm;
  LICE_IFont *m_font;
  int m_font_alpha;
  int m_scroll_offset_y;
  int m_credits_height;
  bool m_calc;
  WDL_TypedBuf<int> m_break;

  HANDLE m_thread;
  bool m_kill_thread;
  WDL_Mutex m_mutex;
};

#endif // _TERPSICHORE_ABOUT_WINDOW_H_
