// Copyright (c) 2022 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _TERPSICHORE_ANTIDOTE_H_
#define _TERPSICHORE_ANTIDOTE_H_

#include "terpsichore/definitions.h"

#include "third_party/libebur128/ebur128/ebur128.h"

#include "WDL/assocarray.h"
#include "WDL/mutex.h"

class RST_Antidote
{
public:
  RST_Antidote();
  ~RST_Antidote();

  void Transcode(const char *filename, bool is_deck, int deck);
  bool IsTranscoding() const;
  int TranscodingProgress() const;
  void AbortTranscoding();
  const char *GetFilename() const;
  void ReleaseFilename(const char *filename);

private:
  int Run();
  void StartThread();
  void StopThread();
  static unsigned int WINAPI ThreadFunction(void *arg);

  HANDLE m_thread;
  bool m_killthread;
  WDL_Mutex m_mutex;
  bool m_cancel;
  bool m_transcoding;
  WDL_FastString m_fn;
  WDL_FastString m_tcfn;
  int m_antidote;
  int m_transcodeprogress;
  bool m_isdeck;
  int m_deck;
  WDL_StringKeyedArray<int> m_releaseref;

  ebur128_state *m_stt;
  int m_ebur128normalization;
  int m_ebur128downwardonly;
  double m_ebur128reference;
  int m_ebur128mode;
  double m_ebur128momentary;
  double m_ebur128shortterm;
  int m_ebur128momentarywindow;
  int m_ebur128shorttermwindow;
  double m_ebur128integrated;
  double m_ebur128range;
  double m_ebur128samplepeak;
  double m_ebur128truepeak;
  double m_ebur128gain;
  int m_momentarywindow;
  int m_shorttermwindow;

  int m_peakrate;
};

#endif // _TERPSICHORE_ANTIDOTE_H_
