// Copyright (c) 2022 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _TERPSICHORE_ANTIDOTE_INPUT_H_
#define _TERPSICHORE_ANTIDOTE_INPUT_H_

#include "terpsichore/terpsichore_plugin.h"
#include "terpsichore/sample_format.h"

#include "WDL/wdlstring.h"
#include "WDL/fileread.h"
#include "WDL/heapbuf.h"
#include "WDL/queue.h"

class RST_AntidoteInput : public RST_IFileInput
{
public:
  RST_AntidoteInput();
  ~RST_AntidoteInput();

  bool Open(const char *filename);

  const char *GetType();

  const char *GetFileName();

  int GetChannels();

  double GetSampleRate();

  double GetLength();

  int GetBitsPerSample();

  double GetPosition();

  void Seek(double time);

  bool IsReverse() const;
  void SetReverse(bool state);

  int GetSamples(SAM *buffer, int length);

  bool IsStreaming();

  int Extended(int call, void *parm1, void *parm2, void *parm3);

private:
  WDL_FileRead *m_fr;
  WDL_FastString m_fn;
  WDL_TypedQueue<SAM> m_buffer_queue;

  bool m_eof;
  double m_position;
  double m_srate;

  WDL_TypedBuf<SAM> m_buffer;
  WDL_HeapBuf m_rawbuf;
  int m_antidote;
  bool m_rev;
};

#endif // _TERPSICHORE_ANTIDOTE_INPUT_H_
