// Copyright (c) 2017 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _TERPSICHORE_INFO_H_
#define _TERPSICHORE_INFO_H_

#include <string.h>

#include "terpsichore/git_sha1.h"

#define TERPSICHORE_MAJOR_VERSION 1
#define TERPSICHORE_MINOR_VERSION 15

#define TERPSICHORE_RELEASE ""
#define TERPSICHORE_SPECIAL ""

#define TERPSICHORE_NAME "terpsichore"
#define TERPSICHORE_NAME_MARKETING "Terpsichore"
#define TERPSICHORE_COMPANY_URL "https://www.grafmin.gr/"
#define TERPSICHORE_WEBSITE_URL "https://www.grafmin.gr/terpsichore"
#define TERPSICHORE_COPYRIGHT "Copyright (c) 2021-2025 Giorgos Vougioukas"

#define TERPSICHORE_STRINGIFY_HELPER(x) #x
#define TERPSICHORE_STRINGIFY(x) TERPSICHORE_STRINGIFY_HELPER(x)

#define TERPSICHORE_NAKED_VERSION \
  TERPSICHORE_STRINGIFY(TERPSICHORE_MAJOR_VERSION) \
  "." TERPSICHORE_STRINGIFY(TERPSICHORE_MINOR_VERSION) \
  TERPSICHORE_RELEASE TERPSICHORE_SPECIAL

#define TERPSICHORE_FULL_VERSION \
  TERPSICHORE_NAME_MARKETING " " TERPSICHORE_NAKED_VERSION

#define TERPSICHORE_GIT_SHA TERPSICHORE_STRINGIFY(GIT_SHA1)

#define TERPSICHORE_TIMESTAMP __DATE__ " " __TIME__

inline bool IsStableRelease()
{
  if (strlen(TERPSICHORE_RELEASE)) return false;

  return true;
}

#if defined(_MSC_VER)
  #if defined(_M_AMD64) || defined(_M_X64)
    #define TERPSICHORE_ARCH "x64"
  #elif defined(_M_IX86)
    #define TERPSICHORE_ARCH "x86"
  #else
    #define TERPSICHORE_ARCH "unk"
  #endif
#elif defined(__linux__) && (defined(__clang__) || defined(__GNUC__))
  #if defined(__amd64__) || defined(__X86_64__)
    #define TERPSICHORE_ARCH "amd64"
  #elif defined(__i386__)
    #define TERPSICHORE_ARCH "i686"
  #else
    #define TERPSICHORE_ARCH "unk"
  #endif
#elif defined(__APPLE__) && (defined(__clang__) || defined(__GNUC__))
  #if defined(__amd64__) || defined(__X86_64__)
    #define TERPSICHORE_ARCH "x86-64"
  #elif defined(__i386__)
    #define TERPSICHORE_ARCH "i386"
  #else
    #define TERPSICHORE_ARCH "unk"
  #endif
#endif

#endif // _TERPSICHORE_INFO_H_
