// Copyright (c) 2020 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _TERPSICHORE_ARTWORK_WINDOW_H_
#define _TERPSICHORE_ARTWORK_WINDOW_H_

#include "terpsichore/definitions.h"
#include "WDL/wingui/wndsize.h"
#include "WDL/wdlstring.h"

class RST_ArtworkWnd
{
public:
  RST_ArtworkWnd();
  ~RST_ArtworkWnd();

  HWND Handle() const;

  static WDL_DLGRET ST_ArtworkWndProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam);

private:
  WDL_DLGRET ArtworkWndProc(UINT msg, WPARAM wparam, LPARAM lparam);
  void LoadArtwork(const char *filename);
  void DoPaint(HWND hwnd, HDC dc);
  void Update();
  void OnInitDialog(WPARAM wparam, LPARAM lparam);
  void OnTimer(WPARAM wparam, LPARAM lparam);
  void OnContextMenu(WPARAM wparam, LPARAM lparam);
  void OnPaint(WPARAM wparam, LPARAM lparam);
  void OnSize(WPARAM wparam, LPARAM lparam);
  void OnDestroy(WPARAM wparam, LPARAM lparam);
  void OnCommand(WPARAM wparam, LPARAM lparam);

  HWND m_hwnd;
  int m_x, m_y, m_w, m_h;
  HMENU m_context_menu;
  LICE_IBitmap *m_bm;
  LICE_IBitmap *m_bmp;
  WDL_WndSizer m_resize;
  WDL_FastString m_last_fn;
};

#endif // _TERPSICHORE_ARTWORK_WINDOW_H_
