// Copyright (c) 2017 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _TERPSICHORE_BUFFER_QUEUE_H_
#define _TERPSICHORE_BUFFER_QUEUE_H_

#include <stdlib.h>
#include <string.h>

#include "terpsichore/sample_format.h"

#include "WDL/heapbuf.h"
#include "WDL/ptrlist.h"
#include "WDL/queue.h"
#include "WDL/mutex.h"

struct BQ_Block
{
  WDL_TypedQueue<SAM> samq;
  double stime;
};

class RST_BufferQueue
{
public:
  RST_BufferQueue();
  ~RST_BufferQueue();

  void AddBlock(WDL_TypedBuf<SAM> *block, double start_time);
  bool GetBlock(BQ_Block **block);
  void ReturnBlock(BQ_Block *block);
  void DisposeBlock(BQ_Block *block);
  int GetSize() const;
  double GetNextRunTime();
  void Flush();
  void Empty();

private:
  WDL_PtrList<BQ_Block> m_blocks;
  WDL_PtrList<BQ_Block> m_empty_blocks;
  WDL_Mutex m_mutex;
  int m_size_bytes;
};

#endif // _TERPSICHORE_BUFFER_QUEUE_H_
