// Copyright (c) 2019 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#include "terpsichore/changelog_wnd.h"
#include "terpsichore/app_info.h"

#define PREVIEW_EDITOR_TIMER 100
#define PREVIEW_EDITOR_TIMER_MS 50

static win32CursesCtx s_curses_ctx;

RST_ChangeLogWnd::RST_ChangeLogWnd()
  : m_hwnd(NULL)
  , m_preview(&s_curses_ctx)
{}

RST_ChangeLogWnd::~RST_ChangeLogWnd()
{}

HWND RST_ChangeLogWnd::Handle() const
{
  return m_hwnd;
}

void RST_ChangeLogWnd::OnInitDialog(WPARAM wparam, LPARAM lparam)
{
  HWND cc = GetDlgItem(m_hwnd, IDC_CUSTOM1);
  curses_setWindowContext(cc, &s_curses_ctx);

  m_resize.init(m_hwnd);
  m_resize.init_itemhwnd(cc, 0.0f, 0.0f, 1.0f, 1.0f);

  int x = g_ini_file->read_int("changelog_wnd_x", 0, TERPSICHORE_NAME);
  int y = g_ini_file->read_int("changelog_wnd_y", 50, TERPSICHORE_NAME);
#if defined(_WIN32)
  SetWindowPos(m_hwnd, NULL, x, y, 620, 505, SWP_NOZORDER | SWP_NOACTIVATE);
#else
  SetWindowPos(m_hwnd, NULL, x, y, 680, 505, SWP_NOZORDER | SWP_NOACTIVATE);
#endif

  WDL_FastString changelog;
  changelog.Set(g_module_path.Get());
  changelog.Append("changelog.txt");

  m_preview.SetParent(m_hwnd);
  m_preview.init(changelog.Get());
  m_preview.draw();
  m_preview.setCursor();

  SetTimer(m_hwnd, PREVIEW_EDITOR_TIMER, PREVIEW_EDITOR_TIMER_MS, NULL);

  SetFocus(cc);
}

void RST_ChangeLogWnd::OnTimer(WPARAM wparam, LPARAM lparam)
{
  if (wparam == PREVIEW_EDITOR_TIMER)
  {
    m_preview.RunEditor();
  }
}

void RST_ChangeLogWnd::OnDestroy(WPARAM wparam, LPARAM lparam)
{
  m_preview.ClearText();
  KillTimer(m_hwnd, PREVIEW_EDITOR_TIMER);

  RECT r;
  GetWindowRect(m_hwnd, &r);

  g_ini_file->write_int("changelog_wnd_x", r.left, TERPSICHORE_NAME);
  g_ini_file->write_int("changelog_wnd_y", r.top, TERPSICHORE_NAME);

  m_hwnd = NULL;
}

void RST_ChangeLogWnd::OnSize(WPARAM wparam, LPARAM lparam)
{
  if (wparam != SIZE_MINIMIZED)
  {
    m_resize.onResize();
  }
}

void RST_ChangeLogWnd::OnCommand(WPARAM wparam, LPARAM lparam)
{
  switch(LOWORD(wparam))
  {
  case IDCANCEL:
    {
      DestroyWindow(m_hwnd);
    }
    break;
  }
}

void RST_ChangeLogWnd::OnSysCommand(WPARAM wparam, LPARAM lparam)
{
  if (LOWORD(wparam) == SC_CLOSE)
  {
    DestroyWindow(m_hwnd);
  }
}

WDL_DLGRET RST_ChangeLogWnd::ST_ChangelogWndProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam)
{
  RST_ChangeLogWnd *self = (RST_ChangeLogWnd *)GetWindowLongPtr(hwnd, GWLP_USERDATA);

  if (!self && msg == WM_INITDIALOG)
  {
    SetWindowLongPtr(hwnd, GWLP_USERDATA, lparam);
    self = (RST_ChangeLogWnd *)lparam;
    self->m_hwnd = hwnd;
  }

  if (WDL_likely(self))
  {
    return self->ChangelogWndProc(msg, wparam, lparam);
  }
  else
  {
    return 0;
  }
}

WDL_DLGRET RST_ChangeLogWnd::ChangelogWndProc(UINT msg, WPARAM wparam, LPARAM lparam)
{
  switch (msg)
  {
    case WM_INITDIALOG: OnInitDialog(wparam, lparam); break;
    case WM_TIMER: OnTimer(wparam, lparam); break;
    case WM_DESTROY: OnDestroy(wparam, lparam); break;
    case WM_SIZE: OnSize(wparam, lparam); break;
    case WM_COMMAND: OnCommand(wparam, lparam); break;
    case WM_SYSCOMMAND: OnSysCommand(wparam, lparam); break;
  }

  return 0;
}
