// Copyright (c) 2019 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _TERPSICHORE_CHANGELOG_WINDOW_H_
#define _TERPSICHORE_CHANGELOG_WINDOW_H_

#include "terpsichore/definitions.h"
#include "terpsichore/editor.h"
#include "WDL/wingui/wndsize.h"

class RST_ChangeLogWnd
{
public:
  RST_ChangeLogWnd();
  ~RST_ChangeLogWnd();

  HWND Handle() const;
  static WDL_DLGRET ST_ChangelogWndProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam);

private:
  WDL_DLGRET ChangelogWndProc(UINT msg, WPARAM wparam, LPARAM lparam);
  void OnInitDialog(WPARAM wparam, LPARAM lparam);
  void OnTimer(WPARAM wparam, LPARAM lparam);
  void OnDestroy(WPARAM wparam, LPARAM lparam);
  void OnSize(WPARAM wparam, LPARAM lparam);
  void OnCommand(WPARAM wparam, LPARAM lparam);
  void OnSysCommand(WPARAM wparam, LPARAM lparam);

  HWND m_hwnd;

  RST_PreviewEditor m_preview;
  WDL_WndSizer m_resize;
};

#endif // _TERPSICHORE_CHANGELOG_WINDOW_H_
