// Copyright (c) 2021 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#include "terpsichore/data_streamer.h"

RST_DataStreamer::RST_DataStreamer()
  : m_thread(NULL)
  , m_kill_thread(false)
{}

RST_DataStreamer::~RST_DataStreamer()
{
  StopThread();
}

void RST_DataStreamer::StartThread()
{
  WDL_ASSERT(m_thread == NULL);

  if (!m_thread)
  {
    unsigned int thread_id;
    m_thread = (HANDLE)_beginthreadex(NULL, 0, ThreadFunction, (void *)this, 0, &thread_id);
  }
}

void RST_DataStreamer::StopThread()
{
  m_kill_thread = true;

  if (m_thread)
  {
    WaitForSingleObject(m_thread, INFINITE);
    CloseHandle(m_thread);
    m_thread = NULL;
  }
}

int RST_DataStreamer::Run()
{
  return 1;
}

unsigned int WINAPI RST_DataStreamer::ThreadFunction(void *arg)
{
#if defined(_WIN32)
  CoInitialize(NULL);
#endif

  RST_DataStreamer *self = (RST_DataStreamer *)arg;

  if (WDL_NORMALLY(self))
  {
    self->m_kill_thread = false;

    while (!self->m_kill_thread)
    {
      self->m_mutex.Enter();
      while (!self->Run());
      self->m_mutex.Leave();
      Sleep(10);
    }
  }

#if defined(_WIN32)
  CoUninitialize();
#endif

  return 0;
}
