// Copyright (c) 2021 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#include "terpsichore/deck.h"

#include "WDL/fpcmp.h"

RST_Deck::RST_Deck()
  : m_active_play(false)
  , m_active_cue(false)
  , m_cue(0.0)
{}

RST_Deck::~RST_Deck()
{}

void RST_Deck::SetState(bool active)
{
  m_active_play = active;
}

bool RST_Deck::IsActive() const
{
  if (m_active_play) return true;
  if (m_active_cue) return true;
  for (int i = 0; i < m_active_hotcue.GetSize(); i++)
  {
    if (m_active_hotcue.Enumerate(i)) return true;
  }
  return false;
}

bool RST_Deck::IsPlayActive() const
{
  return m_active_play;
}

void RST_Deck::EnableCue()
{
  if (!m_active_cue)
  {
    double cue = track.GetRunTime();
    bool drained = track.IsDrained();

    if (m_active_play)
    {
      if (!WDL_ApproximatelyEqual(cue, m_cue))
      {
        m_active_play = false;
        track.Seek(m_cue);
      }
    }
    else
    {
      if (!WDL_ApproximatelyEqual(cue, m_cue) && !drained)
      {
        m_cue = cue;
      }
      track.Seek(m_cue);
    }
  }
  m_active_cue = true;
}

void RST_Deck::DisableCue()
{
  m_active_cue = false;
  if (!m_active_play)
  {
    track.Seek(m_cue);
  }
}

void RST_Deck::SetCue()
{
  m_cue = track.GetRunTime();
}

double RST_Deck::GetCue() const
{
  return m_cue;
}

void RST_Deck::EnableHotCue(int idx)
{
  if (!track.IsOpen()) return;

  if (!m_active_hotcue.Get(idx, false))
  {
    if (!m_hotcue.Exists(idx))
    {
      m_hotcue.Insert(idx, track.GetRunTime());
    }
    else
    {
      track.Seek(m_hotcue.Get(idx));
    }
  }
  m_active_hotcue.Insert(idx, true);
}

void RST_Deck::DisableHotCue(int idx)
{
  m_active_hotcue.Insert(idx, false);

  if (!m_active_play)
  {
    track.Seek(m_hotcue.Get(idx, 0.0));
  }
}

void RST_Deck::ClearHotCue(int idx)
{
  m_hotcue.Delete(idx);
}

WDL_IntKeyedArray<double> *RST_Deck::GetHotCue()
{
  return &m_hotcue;
}
