// Copyright (c) 2021 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _TERPSICHORE_DECK_H_
#define _TERPSICHORE_DECK_H_

#include "terpsichore/track.h"

#include "WDL/assocarray.h"

class RST_Deck
{
public:
  RST_Deck();
  ~RST_Deck();

  void SetState(bool active);
  bool IsActive() const;
  bool IsPlayActive() const;

  void EnableCue();
  void DisableCue();
  void SetCue();
  double GetCue() const;
  void EnableHotCue(int idx);
  void DisableHotCue(int idx);
  void ClearHotCue(int idx);
  WDL_IntKeyedArray<double> *GetHotCue();

  RST_Track track;

private:
  bool m_active_play;

  bool m_active_cue;
  double m_cue;

  WDL_IntKeyedArray<bool> m_active_hotcue;
  WDL_IntKeyedArray<double> m_hotcue;
};

#endif // _TERPSICHORE_DECK_H_
