// Copyright (c) 2021 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#include "terpsichore/decks_wnd.h"
#include "terpsichore/waveform_wnd.h"
#include "terpsichore/main_wnd.h"

#include <math.h>

#include "WDL/fpcmp.h"

static LOGFONT lf =
{
#if defined(_WIN32)
  14, 0, 0, 0, FW_NORMAL, FALSE, FALSE, FALSE, DEFAULT_CHARSET,
  OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS, DEFAULT_QUALITY, DEFAULT_PITCH,
  "Arial"
#else
  11, 0, 0, 0, FW_NORMAL, FALSE, FALSE, FALSE, DEFAULT_CHARSET,
  OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS, DEFAULT_QUALITY, DEFAULT_PITCH,
  "Arial"
#endif
};

static LOGFONT biglf =
{
#if defined(_WIN32)
  20, 0, 0, 0, FW_NORMAL, FALSE, FALSE, FALSE, DEFAULT_CHARSET,
  OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS, DEFAULT_QUALITY, DEFAULT_PITCH,
  "Arial"
#else
  17, 0, 0, 0, FW_NORMAL, FALSE, FALSE, FALSE, DEFAULT_CHARSET,
  OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS, DEFAULT_QUALITY, DEFAULT_PITCH,
  "Arial"
#endif
};

RST_DeckWnd::RST_DeckWnd()
  : m_bm(NULL)
  , m_font(NULL)
  , m_bigfont(NULL)
  , m_align(-1)
  , m_wfc(NULL)
{
#if _WIN32
  WNDCLASS wc = { CS_DBLCLKS, };
  wc.lpfnWndProc = (WNDPROC)RST_WaveformWnd::ST_WaveformWndProc;
  wc.hInstance = g_inst;
  wc.hCursor = LoadCursor(NULL,IDC_ARROW);
  wc.lpszClassName = "waveform_superhost";
  RegisterClass(&wc);
#endif
}

RST_DeckWnd::~RST_DeckWnd()
{
  delete m_bm;
  delete m_font;
  delete m_bigfont;
  m_vwnd.RemoveAllChildren(false);

#if _WIN32
  UnregisterClass("waveform_superhost", g_inst);
#endif
}

HWND RST_DeckWnd::Handle() const
{
  return m_hwnd;
}

void RST_DeckWnd::OnInitDialog(WPARAM wparam, LPARAM lparam)
{
  RECT r;
  GetClientRect(m_hwnd, &r);

  g_deckwnd = m_hwnd;

  if (!m_font) m_font = new LICE_CachedFont;
  if (!m_font->GetHFont())
  {
    m_font->SetFromHFont(CreateFontIndirect(&lf), LICE_FONT_FLAG_OWNS_HFONT);
    m_font->SetTextColor(LICE_RGBA(0, 0, 0, 255));
    m_font->SetBkMode(TRANSPARENT);
  }

  if (!m_bigfont) m_bigfont = new LICE_CachedFont;
  if (!m_bigfont->GetHFont())
  {
    m_bigfont->SetFromHFont(CreateFontIndirect(&biglf), LICE_FONT_FLAG_OWNS_HFONT);
    m_bigfont->SetTextColor(LICE_RGBA(0, 0, 0, 255));
    m_bigfont->SetBkMode(TRANSPARENT);
  }

  int h = 50, tbm = 20, lrm = 5; // height, top-bottom margin, left-right margin

  //RECT sz = { 0, };
  //LICE_SysBitmap bm;
  //m_bigfont->DrawText(&bm, "00:00", -1, &sz, DT_CALCRECT | DT_SINGLELINE | DT_NOPREFIX);
  //tbm = sz.bottom - sz.top;

#ifndef _WIN32
  //SWELL_SetClassName(m_hwnd, "deck_superhost");

  HWND wfc = CreateDialog(NULL, 0, m_hwnd, (DLGPROC)RST_WaveformWnd::ST_WaveformWndProc);
  if (wfc)
  {
    SWELL_SetClassName(wfc, "waveform_superhost");
    ShowWindow(wfc, SW_SHOWNA);
  }

  m_wfc = wfc;
#endif

#if _WIN32
  m_wfc = GetDlgItem(m_hwnd, IDC_CUSTOM1);
#endif

  //int cw = (r.right + 160) - (r.left - lrm);
  //int ch = (r.bottom - lrm) - (r.top + lrm);

  RECT rc;

  if (m_align == 1)
  {
    rc.left = (int)((r.right + lrm) * 0.33f);
    rc.top = r.top + lrm;
    rc.right = r.right - lrm;
    rc.bottom = 110 - lrm;
  }
  else if (m_align == -1)
  {
    rc.left = r.left + lrm;
    rc.top = r.top + lrm;
    rc.right = (r.right - lrm) - (int)((r.right + lrm) * 0.33f);
    rc.bottom = 110 - lrm;
  }

  int cw = (rc.right - rc.left);
  int ch = (rc.bottom - rc.top);
  SetWindowPos(m_wfc, NULL, rc.left, lrm, cw, ch, SWP_NOACTIVATE | SWP_NOZORDER);

  m_bm = new LICE_SysBitmap(cw, ch);
  LICE_Clear(m_bm, LICE_RGBA(51, 51, 51, 255));
  LICE_Line(m_bm, cw / 2, 0, cw / 2, h, LICE_RGBA(255, 0, 0, 255));

  RECT rv;

  if (m_align == 1)
  {
    rv.left = r.left + lrm;
    rv.top = r.top + lrm;
    rv.right = rc.left - lrm;
    rv.bottom = r.bottom - lrm;
  }
  else if (m_align == -1)
  {
    rv.left = rc.right + (lrm * 2);
    rv.top = r.top + lrm;
    rv.right = r.right - lrm;
    rv.bottom = r.bottom - lrm;
  }

  RECT rectim;
  rectim.left = rv.left;
  rectim.top = rv.top;
  rectim.right = rv.right;
  rectim.bottom = rectim.top + tbm;
  m_time.SetPosition(&rectim);
  m_time.SetFont(m_bigfont);
  m_time.SetID(TRK_TITLE);
  m_time.SetRealParent(m_hwnd);
  m_time.SetColors(LICE_RGBA(210, 210, 210, 255));
  m_time.SetText("");

  RECT rectit;
  rectit.left = rv.left;
  rectit.top = rectim.bottom;
  rectit.right = rv.right;
  rectit.bottom = rectit.top + tbm;
  m_title.SetPosition(&rectit);
  m_title.SetFont(m_font);
  m_title.SetID(TRK_TITLE);
  m_title.SetRealParent(m_hwnd);
  m_title.SetColors(LICE_RGBA(210, 210, 210, 255));
  m_title.SetText("");

  RECT rectart;
  rectart.left = rv.left;
  rectart.top = rectit.bottom;
  rectart.right = rv.right;
  rectart.bottom = rectart.top + tbm;
  m_artist.SetPosition(&rectart);
  m_artist.SetFont(m_font);
  m_artist.SetID(TRK_TITLE);
  m_artist.SetRealParent(m_hwnd);
  m_artist.SetColors(LICE_RGBA(210, 210, 210, 255));
  m_artist.SetText("");

  RECT rectfad;
  rectfad.left = rv.left;
  rectfad.top = rectart.bottom;
  rectfad.right = rv.right;
  rectfad.bottom = rectfad.top + tbm;
  m_fader.SetPosition(&rectfad);
  m_fader.SetFont(m_font);
  m_fader.SetID(TRK_TITLE);
  m_fader.SetRealParent(m_hwnd);
  m_fader.SetColors(LICE_RGBA(210, 210, 210, 255));
  m_fader.SetText("");

  RECT rectcue;
  rectcue.left = rv.left;
  rectcue.top = rectfad.bottom;
  rectcue.right = rv.right;
  rectcue.bottom = rectcue.top + tbm;
  m_cuept.SetPosition(&rectcue);
  m_cuept.SetFont(m_font);
  m_cuept.SetID(TRK_TITLE);
  m_cuept.SetRealParent(m_hwnd);
  m_cuept.SetColors(LICE_RGBA(210, 210, 210, 255));
  m_cuept.SetText("");

  for (int i = 0; i < 4; i++)
  {
    RECT recthot[4];
    if (i == 0) recthot[i].left = r.left + lrm;
    else recthot[i].left = r.left + lrm + (recthot[0].right * i);
    recthot[i].top = rc.bottom;
    recthot[i].right = recthot[i].left + (r.right - lrm) / 4;
    recthot[i].bottom = recthot[i].top + tbm;
    m_hotcue[i].SetPosition(&recthot[i]);
    m_hotcue[i].SetFont(m_font);
    m_hotcue[i].SetID(TRK_TITLE);
    m_hotcue[i].SetRealParent(m_hwnd);
    m_hotcue[i].SetColors(LICE_RGBA(210, 210, 210, 255));
    m_hotcue[i].SetText("");
  }

  m_vwnd.SetPosition(&r);
  m_vwnd.SetRealParent(m_hwnd);
  m_vwnd.AddChild(&m_time);
  m_vwnd.AddChild(&m_title);
  m_vwnd.AddChild(&m_artist);
  m_vwnd.AddChild(&m_fader);
  m_vwnd.AddChild(&m_cuept);
  m_vwnd.AddChild(&m_hotcue[0]);
  m_vwnd.AddChild(&m_hotcue[1]);
  m_vwnd.AddChild(&m_hotcue[2]);
  m_vwnd.AddChild(&m_hotcue[3]);

  m_resize.init(m_hwnd);

  if (m_align == 1)
  {
    m_resize.init_itemvirt(&m_vwnd, 0.0f, 0.0f, 1.0f, 0.0f);
    m_resize.init_itemvirt(&m_time, 0.0f, 0.0f, 0.0f, 0.0f);
    m_resize.init_itemvirt(&m_title, 0.0f, 0.0f, 0.0f, 0.0f);
    m_resize.init_itemvirt(&m_artist, 0.0f, 0.0f, 0.0f, 0.0f);
    m_resize.init_itemvirt(&m_fader, 0.0f, 0.0f, 0.0f, 0.0f);
    m_resize.init_itemvirt(&m_cuept, 0.0f, 0.0f, 0.0f, 0.0f);
    m_resize.init_itemvirt(&m_hotcue[0], 0.0f, 0.0f, 0.0f, 0.0f);
    m_resize.init_itemvirt(&m_hotcue[1], 0.0f, 0.0f, 0.0f, 0.0f);
    m_resize.init_itemvirt(&m_hotcue[2], 0.0f, 0.0f, 0.0f, 0.0f);
    m_resize.init_itemvirt(&m_hotcue[3], 0.0f, 0.0f, 0.0f, 0.0f);
    m_resize.init_itemhwnd(m_wfc, 0.0f, 0.0f, 1.0f, 0.0f);
  }
  else if (m_align == -1)
  {
    m_resize.init_itemvirt(&m_vwnd, 0.0f, 0.0f, 1.0f, 0.0f);
    m_resize.init_itemvirt(&m_time, 1.0f, 0.0f, 1.0f, 0.0f);
    m_resize.init_itemvirt(&m_title, 1.0f, 0.0f, 1.0f, 0.0f);
    m_resize.init_itemvirt(&m_artist, 1.0f, 0.0f, 1.0f, 0.0f);
    m_resize.init_itemvirt(&m_fader, 1.0f, 0.0f, 1.0f, 0.0f);
    m_resize.init_itemvirt(&m_cuept, 1.0f, 0.0f, 1.0f, 0.0f);
    m_resize.init_itemvirt(&m_hotcue[0], 0.0f, 0.0f, 0.0f, 0.0f);
    m_resize.init_itemvirt(&m_hotcue[1], 0.0f, 0.0f, 0.0f, 0.0f);
    m_resize.init_itemvirt(&m_hotcue[2], 0.0f, 0.0f, 0.0f, 0.0f);
    m_resize.init_itemvirt(&m_hotcue[3], 0.0f, 0.0f, 0.0f, 0.0f);
    m_resize.init_itemhwnd(m_wfc, 0.0f, 0.0f, 1.0f, 0.0f);
  }

  InvalidateRect(m_hwnd, NULL, FALSE);

  ShowWindow(m_hwnd, SW_NORMAL);
}

void RST_DeckWnd::OnPaint(WPARAM wparam, LPARAM lparam)
{
  m_painter.PaintBegin(m_hwnd, RGB(51, 51, 51));
  m_painter.PaintVirtWnd(&m_vwnd);
  m_painter.PaintEnd();
}

void RST_DeckWnd::OnSize(WPARAM wparam, LPARAM lparam)
{
  if (wparam != SIZE_MINIMIZED)
  {
    m_resize.onResize();

    RECT r;
    GetClientRect(m_wfc, &r);
    m_bm->resize(r.right - r.left, r.bottom - r.top);
  }
}

void RST_DeckWnd::OnDestroy(WPARAM wparam, LPARAM lparam)
{}

WDL_DLGRET RST_DeckWnd::DeckWndProc(UINT msg, WPARAM wparam, LPARAM lparam)
{
  switch (msg)
  {
    case WM_INITDIALOG: OnInitDialog(wparam, lparam); break;
    case WM_PAINT: OnPaint(wparam, lparam); break;
    case WM_SIZE: OnSize(wparam, lparam); break;
    case WM_DESTROY: OnDestroy(wparam, lparam); break;
    //case WM_ERASEBKGND: return 1; break;
  }

  return 0;
}


RST_DeckAWnd::RST_DeckAWnd()
{}

RST_DeckAWnd::~RST_DeckAWnd()
{}

void RST_DeckAWnd::UpdateInfo()
{
  double time, duration, cue;
  int mins, secs, msec, currange;
  int dmins, dsecs, dmsec;
  int cmins, csecs, cmsec;
  WDL_IntKeyedArray<double> *hotcue;
  double fader;

  g_main_loop_mutex.Enter();
  time = g_main_loop->GetRunTimeDeckA();
  duration = g_main_loop->GetDurationDeckA();
  cue = g_main_loop->GetCueDeckA();
  hotcue = g_main_loop->GetHotCueDeckA();
  fader = g_main_loop->GetFaderDecibelDeckA();
  m_title.SetText(g_main_loop->GetTitleDeckA());
  m_artist.SetText(g_main_loop->GetArtistDeckA());
  g_main_loop_mutex.Leave();

  mins = secs = msec = currange = 0;
  dmins = dsecs = dmsec = 0;
  cmins = csecs = cmsec = 0;

  if (WDL_DefinitelyGreaterThan(time, 0.0))
  {
    //currange = (int)(time / duration * 100);

    //if (!is_time_elapsed)
    //{
    //  time = duration - time;
    //}

    mins = (int)time / 60;
    secs = (int)time % 60;
    msec = (int)((time - (int)time) * 1000);
    //msec = (int)(time * 1000) % 1000;
  }

  if (WDL_DefinitelyGreaterThan(duration, 0.0))
  {
    dmins = (int)duration / 60;
    dsecs = (int)duration % 60;
    dmsec = (int)((duration - (int)duration) * 1000);
  }

  if (WDL_DefinitelyGreaterThan(cue, 0.0))
  {
    cmins = (int)cue / 60;
    csecs = (int)cue % 60;
    cmsec = (int)((cue - (int)cue) * 1000);
  }

  m_strbuf.SetFormatted(64,
    "A: %01d:%02d.%03d / %01d:%02d",
    mins, secs, msec, dmins, dsecs);

  m_time.SetText(m_strbuf.Get());

  if (WDL_ApproximatelyEqual(fader, -150.0))
  {
    m_strbuf.Set("FDR: -inf dB");
  }
  else
  {
    m_strbuf.SetFormatted(128, "FDR: %.02fdB", fader);
  }

  m_fader.SetText(m_strbuf.Get());

  m_strbuf.SetFormatted(128, "CP: %01d:%02d.%03d", cmins, csecs, cmsec);
  m_cuept.SetText(m_strbuf.Get());

  for (int i = 0; i < 4; i++)
  {
    m_hotcue[i].SetText("");
  }

  for (int i = 0; i < hotcue->GetSize(); i++)
  {
    int hcmins = 0, hcsecs = 0, hcmsec = 0, key;

    double hctime = hotcue->Enumerate(i, &key);

    if (WDL_DefinitelyGreaterThan(hctime, 0.0))
    {
      hcmins = (int)hctime / 60;
      hcsecs = (int)hctime % 60;
      hcmsec = (int)((hctime - (int)hctime) * 1000);
    }
    m_strbuf.SetFormatted(128, "HC%d: %01d:%02d.%03d", key, hcmins, hcsecs, hcmsec);
    m_hotcue[i].SetText(m_strbuf.Get());
  }

  RECT r;
  GetWindowRect(m_wfc, &r);
  ScreenToClient(m_hwnd, (LPPOINT)&r);
  ScreenToClient(m_hwnd, ((LPPOINT)&r)+1);
  InvalidateRect(m_hwnd, &r, FALSE);
}

void RST_DeckAWnd::DoPaint(HWND hwnd, HDC dc)
{
#if 0
  int w = m_bm->getWidth();
  int h = m_bm->getHeight();

  LICE_Clear(m_bm, LICE_RGBA(255, 255, 255, 255));

  RST_Deck *da = g_main_loop->GetDeckA();

  if (da)
  {
    LICE_IBitmap *wf = da->track.GetWaveForm();
    int pkrate = da->track.GetPeakRate();
    double rt = da->track.GetRunTime();

    int pos = (int)(rt * pkrate);

    if (wf)
    {
      LICE_Blit(m_bm, wf, 0, 0, pos - (w / 2), 0, w / 2, h, 1.0f, LICE_BLIT_MODE_COPY);
      LICE_Blit(m_bm, wf, w / 2, 0, pos, 0, w / 2, h, 1.0f, LICE_BLIT_MODE_COPY);
    }
  }

  LICE_Line(m_bm, w / 2, 0, w / 2, h, LICE_RGBA(255, 0, 0, 255));
  BitBlt(dc, 0, 0, w, h, m_bm->getDC(), 0, 0, SRCCOPY);
#endif
}

void RST_DeckAWnd::OnInitDialog(WPARAM wparam, LPARAM lparam)
{
  m_align = -1;
  g_decka_wnd = this;
  RST_DeckWnd::OnInitDialog(wparam, lparam);
}

void RST_DeckAWnd::OnPaint(WPARAM wparam, LPARAM lparam)
{
#if 0
  PAINTSTRUCT ps;
  HDC dc = BeginPaint(m_wfc, &ps);
  DoPaint(m_hwnd, dc);
  EndPaint(m_wfc, &ps);
#endif

  RST_DeckWnd::OnPaint(wparam, lparam);
}

void RST_DeckAWnd::OnSize(WPARAM wparam, LPARAM lparam)
{
  RST_DeckWnd::OnSize(wparam, lparam);
}

WDL_DLGRET RST_DeckAWnd::ST_DeckAWndProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam)
{
  RST_DeckAWnd *self = (RST_DeckAWnd *)GetWindowLongPtr(hwnd, GWLP_USERDATA);

  if (!self && msg == WM_INITDIALOG)
  {
    SetWindowLongPtr(hwnd, GWLP_USERDATA, lparam);
    self = (RST_DeckAWnd *)lparam;
    self->m_hwnd = hwnd;
  }

  if (WDL_likely(self))
  {
    return self->DeckWndProc(msg, wparam, lparam);
  }
  else
  {
    return 0;
  }
}


RST_DeckBWnd::RST_DeckBWnd()
{}

RST_DeckBWnd::~RST_DeckBWnd()
{}

void RST_DeckBWnd::UpdateInfo()
{
  double time, duration, cue;
  int mins, secs, msec, currange;
  int dmins, dsecs, dmsec;
  int cmins, csecs, cmsec;
  WDL_IntKeyedArray<double> *hotcue;
  double fader;

  g_main_loop_mutex.Enter();
  time = g_main_loop->GetRunTimeDeckB();
  duration = g_main_loop->GetDurationDeckB();
  cue = g_main_loop->GetCueDeckB();
  hotcue = g_main_loop->GetHotCueDeckB();
  fader = g_main_loop->GetFaderDecibelDeckB();
  m_title.SetText(g_main_loop->GetTitleDeckB());
  m_artist.SetText(g_main_loop->GetArtistDeckB());
  g_main_loop_mutex.Leave();

  mins = secs = msec = currange = 0;
  dmins = dsecs = dmsec = 0;
  cmins = csecs = cmsec = 0;

  if (WDL_DefinitelyGreaterThan(time, 0.0))
  {
    //currange = (int)(time / duration * 100);

    //if (!is_time_elapsed)
    //{
    //  time = duration - time;
    //}

    mins = (int)time / 60;
    secs = (int)time % 60;
    msec = (int)((time - (int)time) * 1000);
    //msec = (int)(time * 1000) % 1000;
  }

  if (WDL_DefinitelyGreaterThan(duration, 0.0))
  {
    dmins = (int)duration / 60;
    dsecs = (int)duration % 60;
    dmsec = (int)((duration - (int)duration) * 1000);
  }

  if (WDL_DefinitelyGreaterThan(cue, 0.0))
  {
    cmins = (int)cue / 60;
    csecs = (int)cue % 60;
    cmsec = (int)((cue - (int)cue) * 1000);
  }

  m_strbuf.SetFormatted(64,
    "B: %01d:%02d.%03d / %01d:%02d",
    mins, secs, msec, dmins, dsecs);

  m_time.SetText(m_strbuf.Get());

  if (WDL_ApproximatelyEqual(fader, -150.0))
  {
    m_strbuf.Set("FDR: -inf dB");
  }
  else
  {
    m_strbuf.SetFormatted(128, "FDR: %.02fdB", fader);
  }

  m_fader.SetText(m_strbuf.Get());

  m_strbuf.SetFormatted(128, "CP: %01d:%02d.%03d", cmins, csecs, cmsec);
  m_cuept.SetText(m_strbuf.Get());

  for (int i = 0; i < 4; i++)
  {
    m_hotcue[i].SetText("");
  }

  for (int i = 0; i < hotcue->GetSize(); i++)
  {
    int hcmins = 0, hcsecs = 0, hcmsec = 0, key;

    double hctime = hotcue->Enumerate(i, &key);

    if (WDL_DefinitelyGreaterThan(hctime, 0.0))
    {
      hcmins = (int)hctime / 60;
      hcsecs = (int)hctime % 60;
      hcmsec = (int)((hctime - (int)hctime) * 1000);
    }
    m_strbuf.SetFormatted(128, "HC%d: %01d:%02d.%03d", key, hcmins, hcsecs, hcmsec);
    m_hotcue[i].SetText(m_strbuf.Get());
  }

  RECT r;
  GetWindowRect(m_wfc, &r);
  ScreenToClient(m_hwnd, (LPPOINT)&r);
  ScreenToClient(m_hwnd, ((LPPOINT)&r)+1);
  InvalidateRect(m_hwnd, &r, FALSE);
}

void RST_DeckBWnd::DoPaint(HWND hwnd, HDC dc)
{
#if 0
  int w = m_bm->getWidth();
  int h = m_bm->getHeight();

  LICE_Clear(m_bm, LICE_RGBA(255, 255, 255, 255));

  RST_Deck *db = g_main_loop->GetDeckB();

  if (db)
  {
    LICE_IBitmap *wf = db->track.GetWaveForm();
    int pkrate = db->track.GetPeakRate();
    double rt = db->track.GetRunTime();

    int pos = (int)(rt * pkrate);

    if (wf)
    {
      LICE_Blit(m_bm, wf, 0, 0, pos - (w / 2), 0, w / 2, h, 1.0f, LICE_BLIT_MODE_COPY);
      LICE_Blit(m_bm, wf, w / 2, 0, pos, 0, w / 2, h, 1.0f, LICE_BLIT_MODE_COPY);
    }
  }

  LICE_Line(m_bm, w / 2, 0, w / 2, h, LICE_RGBA(255, 0, 0, 255));
  BitBlt(dc, 0, 0, w, h, m_bm->getDC(), 0, 0, SRCCOPY);
#endif
}

void RST_DeckBWnd::OnInitDialog(WPARAM wparam, LPARAM lparam)
{
  m_align = 1;
  g_deckb_wnd = this;
  RST_DeckWnd::OnInitDialog(wparam, lparam);
}

void RST_DeckBWnd::OnPaint(WPARAM wparam, LPARAM lparam)
{
#if 0
  PAINTSTRUCT ps;
  HDC dc = BeginPaint(m_wfc, &ps);
  DoPaint(m_hwnd, dc);
  EndPaint(m_wfc, &ps);
#endif

  RST_DeckWnd::OnPaint(wparam, lparam);
}

WDL_DLGRET RST_DeckBWnd::ST_DeckBWndProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam)
{
  RST_DeckBWnd *self = (RST_DeckBWnd *)GetWindowLongPtr(hwnd, GWLP_USERDATA);

  if (!self && msg == WM_INITDIALOG)
  {
    SetWindowLongPtr(hwnd, GWLP_USERDATA, lparam);
    self = (RST_DeckBWnd *)lparam;
    self->m_hwnd = hwnd;
  }

  if (WDL_likely(self))
  {
    return self->DeckWndProc(msg, wparam, lparam);
  }
  else
  {
    return 0;
  }
}


RST_DecksWnd::RST_DecksWnd()
  : m_hwnd(NULL)
{}

RST_DecksWnd::~RST_DecksWnd()
{}

HWND RST_DecksWnd::Handle()
{
  return m_hwnd;
}

void RST_DecksWnd::UpdateInfo()
{
  m_decka_wnd.UpdateInfo();
  m_deckb_wnd.UpdateInfo();
}

WDL_DLGRET RST_DecksWnd::ST_DecksWndProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam)
{
  RST_DecksWnd *self = (RST_DecksWnd *)GetWindowLongPtr(hwnd, GWLP_USERDATA);

  if (!self && msg == WM_INITDIALOG)
  {
    SetWindowLongPtr(hwnd, GWLP_USERDATA, lparam);
    self = (RST_DecksWnd *)lparam;
    self->m_hwnd = hwnd;
  }

  if (WDL_likely(self))
  {
    return self->DecksWndProc(msg, wparam, lparam);
  }
  else
  {
    return 0;
  }
}

void RST_DecksWnd::DoPaint(HWND hwnd, HDC dc)
{
#if 0
  int w = m_bm->getWidth();
  int h = m_bm->getHeight();
  int hw = w / 2;
  int hh = h / 2;
  int qh = h / 4;

  RST_Deck *da = g_main_loop->GetDeckA();
  RST_Deck *db = g_main_loop->GetDeckB();

  float *peaksa = da->track.GetPeaks();
  WDL_INT64 peakssizea = da->track.GetPeaksSize();
  int peaksratea = da->track.GetPeaksRate();
  int peaksncha = da->track.GetPeaksChannels();
  double rt = da->track.GetRunTime();

  //LICE_Clear(m_bm, LICE_RGBA(0, 0, 0, 255));
  LICE_Clear(m_bm, LICE_RGBA(255, 255, 255, 255));

  WDL_INT64 pos = (WDL_INT64)(rt * peaksratea * peaksncha);

  LICE_SysBitmap bm(w * 2, h);
  LICE_Clear(&bm, LICE_RGBA(255, 255, 255, 255));

  int lineindex = 0;
  for (WDL_INT64 i = pos; i < peakssizea; i += peaksncha)
  {
    int lineheight = (int)(peaksa[i] * h);
    int y1 = (h - lineheight) / 2;
    int y2 = y1 + lineheight;

    LICE_Line(&bm, lineindex, y1, lineindex, y2, LICE_RGBA(0, 0, 0, 255));
    lineindex++;

    if (lineindex >= w) break;
  }

  int posoffset = 0;

  //LICE_Blit(m_bm, &bm, 0, 0, posoffset - (w / 2), 0, w / 2, h, 1.0f, LICE_BLIT_MODE_COPY);
  LICE_Blit(m_bm, &bm, w / 2, 0, posoffset, 0, w / 2, h, 1.0f, LICE_BLIT_MODE_COPY);
  LICE_Line(m_bm, w / 2, 0, w / 2, h, LICE_RGBA(255, 0, 0, 255));

  BitBlt(dc, 0, 0, w, h, m_bm->getDC(), 0, 0, SRCCOPY);
#endif
}

void RST_DecksWnd::OnInitDialog(WPARAM wparam, LPARAM lparam)
{
  RECT r;
  GetClientRect(m_hwnd, &r);
  //ScreenToClient(m_hwnd, (LPPOINT)&r);
  //ScreenToClient(m_hwnd, ((LPPOINT)&r)+1);
  int decksize = (int)((r.right - r.left) / 2);
  int h = r.bottom - r.top;

  CreateDialogParam(g_inst, MAKEINTRESOURCE(IDD_DECK), m_hwnd,
    RST_DeckAWnd::ST_DeckAWndProc, (LPARAM)&m_decka_wnd);
  SetWindowPos(m_decka_wnd.Handle(), NULL, 0, 0,
    decksize, h, SWP_NOACTIVATE | SWP_NOZORDER);
  CreateDialogParam(g_inst, MAKEINTRESOURCE(IDD_DECK), m_hwnd,
    RST_DeckBWnd::ST_DeckBWndProc, (LPARAM)&m_deckb_wnd);
  SetWindowPos(m_deckb_wnd.Handle(), NULL, decksize,
    0, decksize, h, SWP_NOACTIVATE | SWP_NOZORDER);

  m_resize.init(m_hwnd);
  m_resize.init_itemhwnd(m_decka_wnd.Handle(), 0.0f, 0.0f, 0.5f, 1.0f);
  m_resize.init_itemhwnd(m_deckb_wnd.Handle(), 0.5f, 0.0f, 1.0f, 1.0f);

  ShowWindow(m_hwnd, SW_NORMAL);
}

void RST_DecksWnd::OnPaint(WPARAM wparam, LPARAM lparam)
{
  m_painter.PaintBegin(m_hwnd, RGB(51, 51, 51));
  m_painter.PaintEnd();
}

void RST_DecksWnd::OnSize(WPARAM wparam, LPARAM lparam)
{
  if (wparam != SIZE_MINIMIZED)
  {
    m_resize.onResize();
  }
}

void RST_DecksWnd::OnDestroy(WPARAM wparam, LPARAM lparam)
{
  DestroyWindow(m_decka_wnd.Handle());
  DestroyWindow(m_deckb_wnd.Handle());
}

WDL_DLGRET RST_DecksWnd::DecksWndProc(UINT msg, WPARAM wparam, LPARAM lparam)
{
  switch (msg)
  {
    case WM_INITDIALOG: OnInitDialog(wparam, lparam); break;
    case WM_PAINT: OnPaint(wparam, lparam); break;
    case WM_SIZE: OnSize(wparam, lparam); break;
    case WM_DESTROY: OnDestroy(wparam, lparam); break;
    //case WM_ERASEBKGND: return 1; break;
  }

  return 0;
}
