// Copyright (c) 2021 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _TERPSICHORE_DECKS_WINDOW_H_
#define _TERPSICHORE_DECKS_WINDOW_H_

#include "terpsichore/definitions.h"

#include "WDL/lice/lice.h"
#include "WDL/wingui/wndsize.h"
#include "WDL/wingui/virtwnd.h"
#include "WDL/wdlstring.h"

class RST_DeckWnd
{
public:
  RST_DeckWnd();
  virtual ~RST_DeckWnd();

  virtual HWND Handle() const;

protected:
  virtual WDL_DLGRET DeckWndProc(UINT msg, WPARAM wparam, LPARAM lparam);
  virtual void OnInitDialog(WPARAM wparam, LPARAM lparam);
  virtual void OnPaint(WPARAM wparam, LPARAM lparam);
  virtual void OnSize(WPARAM wparam, LPARAM lparam);
  virtual void OnDestroy(WPARAM wparam, LPARAM lparam);

  enum
  {
    TRK_TITLE,
    TRK_ARTIST
  };

  HWND m_hwnd;
  LICE_IBitmap *m_bm;
  LICE_IFont *m_font;
  LICE_IFont *m_bigfont;
  WDL_FastString m_strbuf;
  WDL_VWnd_Painter m_painter;
  WDL_WndSizer m_resize;
  WDL_VWnd m_vwnd;
  WDL_VirtualStaticText m_time;
  WDL_VirtualStaticText m_title;
  WDL_VirtualStaticText m_artist;
  WDL_VirtualStaticText m_fader;
  WDL_VirtualStaticText m_cuept;
  WDL_VirtualStaticText m_hotcue[4];

  int m_align;
  HWND m_wfc;
};

class RST_DeckAWnd : public RST_DeckWnd
{
public:
  RST_DeckAWnd();
  ~RST_DeckAWnd();

  void UpdateInfo();
  HWND GetWaveFormControl() const { return m_wfc; }

  static WDL_DLGRET ST_DeckAWndProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam);
private:
  void DoPaint(HWND hwnd, HDC dc);
  void OnInitDialog(WPARAM wparam, LPARAM lparam);
  void OnPaint(WPARAM wparam, LPARAM lparam);
  void OnSize(WPARAM wparam, LPARAM lparam);
};

class RST_DeckBWnd : public RST_DeckWnd
{
public:
  RST_DeckBWnd();
  ~RST_DeckBWnd();

  void UpdateInfo();
  HWND GetWaveFormControl() const { return m_wfc; }

  static WDL_DLGRET ST_DeckBWndProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam);
private:
  void DoPaint(HWND hwnd, HDC dc);
  void OnInitDialog(WPARAM wparam, LPARAM lparam);
  void OnPaint(WPARAM wparam, LPARAM lparam);
};

class RST_DecksWnd
{
public:
  RST_DecksWnd();
  ~RST_DecksWnd();

  HWND Handle();
  void UpdateInfo();

  static WDL_DLGRET ST_DecksWndProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam);
private:
  WDL_DLGRET DecksWndProc(UINT msg, WPARAM wparam, LPARAM lparam);
  void DoPaint(HWND hwnd, HDC dc);
  void OnInitDialog(WPARAM wparam, LPARAM lparam);
  void OnPaint(WPARAM wparam, LPARAM lparam);
  void OnSize(WPARAM wparam, LPARAM lparam);
  void OnDestroy(WPARAM wparam, LPARAM lparam);

  HWND m_hwnd;
  WDL_VWnd_Painter m_painter;
  WDL_WndSizer m_resize;

  RST_DeckAWnd m_decka_wnd;
  RST_DeckBWnd m_deckb_wnd;
};

#endif // _TERPSICHORE_DECKS_WINDOW_H_
