// Copyright (c) 2019 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#include "terpsichore/definitions.h"

#include "terpsichore/terpsichore_plugin.h"
#include "terpsichore/main_wnd.h"
#include "terpsichore/playlist_wnd.h"
#include "terpsichore/decks_wnd.h"
#include "terpsichore/antidote.h"

#include "WDL/mutex.h"

static void free_str(const char *p) { free((void *)p); }

#if defined(__linux__)
bool has_requested_quit = false;
#endif

WDL_FastString g_media_ext(".flac .mp3");

RST_MainLoop *g_main_loop = NULL;
WDL_Mutex g_main_loop_mutex;
int g_main_loop_done = 0;
WDL_TypedBuf<HANDLE> g_main_loop_thread;

RST_IAudioStreamer *g_audio_streamer = NULL;

WDL_FastString g_ini_path;
RST_IniFile *g_ini_file = NULL;

WDL_FastString g_settings_path;
WDL_FastString g_module_path;

RST_ITheme *g_theme = NULL;
RST_IconTheme g_icon_theme;
RST_KeyboardMap *g_keymap = NULL;
RST_Antidote g_antidote;

HINSTANCE g_inst = NULL;

RST_Settings *g_preference_settings = NULL;
RST_Settings *g_device_settings = NULL;

UINT g_scroll_message;

RST_MainWnd *g_main_wnd = NULL;
RST_PlayListWnd *g_playlist_wnd = NULL;
HWND g_loadwnd = NULL;
HWND g_deckwnd = NULL;
RST_DeckAWnd *g_decka_wnd = NULL;
RST_DeckBWnd *g_deckb_wnd = NULL;

WDL_PtrKeyedArray<const char *> g_plugin_import(free_str);
WDL_StringKeyedArray<void *> g_plugin_export;

const char *GetClientIniPath()
{
  return g_ini_path.Get();
}

const char *GetClientSettingsPath()
{
  return g_settings_path.Get();
}

double GetHardwareSampleRate()
{
  if (!g_audio_streamer) return 0.0;
  return g_audio_streamer->GetSampleRate();
}

int GetResamplerSinc()
{
  int sinc = g_ini_file->read_int("resampler_sinc", 64, "preferences");
  return sinc;
}

int AudioOnSamples(WDL_TypedBuf<SAM> *output, int frame_count, int nch)
{
  g_main_loop->AudioOutput(output, frame_count, nch);
  return 0;
}

int GetDiskReadMode()
{
  int readmode = g_ini_file->read_int("read_mode", 2, "preferences");
  return readmode;
}

int GetDiskReadBufferSize()
{
  int readbuffer = g_ini_file->read_int("read_buffer", 262144, "preferences");
  return readbuffer;
}

int GetDiskReadBuffers()
{
  int readbuffers = g_ini_file->read_int("read_buffers", 3, "preferences");
  return readbuffers;
}
