// Copyright (c) 2019 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _TERPSICHORE_DEFINITIONS_H_
#define _TERPSICHORE_DEFINITIONS_H_

#if defined(_WIN32)
  #include <windows.h>
  #include <windowsx.h>
  #include <commctrl.h>
  #include <process.h>
#else
  #include "WDL/swell/swell.h"
  #include "WDL/swell/swell-functions.h"
#endif

#include "terpsichore/terpsichore_plugin.h"
#include "terpsichore/main_loop.h"
#include "terpsichore/icon_theme.h"
#include "terpsichore/ini_file.h"
#include "terpsichore/settings.h"
#include "terpsichore/keyboard_map.h"
#include "terpsichore/theme.h"
#include "terpsichore/res/resource.h"

#include "WDL/heapbuf.h"
#include "WDL/assocarray.h"
#include "WDL/win32_utf8.h"
#include "WDL/wdlstring.h"
#include "WDL/wdlutf8.h"

#ifndef WM_MOUSEWHEEL
#define WM_MOUSEWHEEL 0x020A
#endif

#ifndef WM_MOUSEHWHEEL
#define WM_MOUSEHWHEEL 0x020E
#endif

class RST_MainWnd;
class RST_PlayListWnd;
class RST_DeckAWnd;
class RST_DeckBWnd;
class RST_Settings;
class RST_IAudioStreamer;
class RST_Antidote;
class WDL_Mutex;

#if defined(__linux__)
extern bool has_requested_quit;
#endif

extern WDL_FastString g_media_ext;

extern RST_MainLoop *g_main_loop;
extern WDL_Mutex g_main_loop_mutex;
extern int g_main_loop_done;
extern WDL_TypedBuf<HANDLE> g_main_loop_thread;

extern RST_IAudioStreamer *g_audio_streamer;

extern WDL_FastString g_ini_path;
extern RST_IniFile *g_ini_file;

extern WDL_FastString g_settings_path;
extern WDL_FastString g_module_path;

extern RST_ITheme *g_theme;
extern RST_IconTheme g_icon_theme;
extern RST_KeyboardMap *g_keymap;
extern RST_Antidote g_antidote;

extern HINSTANCE g_inst;

extern RST_Settings *g_preference_settings;
extern RST_Settings *g_device_settings;

extern UINT g_scroll_message;

extern RST_MainWnd *g_main_wnd;
extern RST_PlayListWnd *g_playlist_wnd;
extern HWND g_loadwnd;
extern HWND g_deckwnd;
extern RST_DeckAWnd *g_decka_wnd;
extern RST_DeckBWnd *g_deckb_wnd;

extern WDL_PtrKeyedArray<const char *> g_plugin_import;
extern WDL_StringKeyedArray<void *> g_plugin_export;

extern WDL_DLGRET RST_LoadWndProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam);

//extern const char *GetClientIniPath();
extern const char *GetClientSettingsPath();
extern double GetHardwareSampleRate();
extern int GetResamplerSinc();
extern int AudioOnSamples(WDL_TypedBuf<SAM> *output, int frame_count, int nch);
extern int GetDiskReadMode();
extern int GetDiskReadBufferSize();
extern int GetDiskReadBuffers();

#endif // _TERPSICHORE_DEFINITIONS_H_
