// Copyright (c) 2019 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _TERPSICHORE_NCURSES_EDITOR_H_
#define _TERPSICHORE_NCURSES_EDITOR_H_

#ifndef CURSES_INSTANCE
#define CURSES_INSTANCE ((win32CursesCtx *)m_cursesCtx)
#endif

#include <string.h>
#include <stdlib.h>

#include "terpsichore/definitions.h"
#include "WDL/win32_curses/curses.h"
#include "WDL/win32_curses/curses_editor.h"
// Time to panic
//#undef move
//#undef erase
//#undef sync

#define WM_TOGGLE_FOCUS (WM_USER + 200)

class RST_PreviewEditor : public WDL_CursesEditor
{
public:
  RST_PreviewEditor(void *curses_ctx);
  ~RST_PreviewEditor();

  void ClearText();

  void SetParent(HWND parent);
  int onChar(int c);

private:
  HWND m_parent;
};

class RST_SimpleEditor : public WDL_CursesEditor
{
public:
  RST_SimpleEditor(void *curses_ctx);
  ~RST_SimpleEditor();

  void ClearText();

  void SetParent(HWND parent);
  int onChar(int c);

  void draw_bottom_line();

private:
  HWND m_parent;
};

#endif // _TERPSICHORE_NCURSES_EDITOR_H_
