// Copyright (c) 2020 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#include "terpsichore/file_prog_wnd.h"
#include "terpsichore/app_info.h"
#include "terpsichore/main_wnd.h"
#include "terpsichore/file_tasks.h"

#define RST_FILE_TASKS_PROGRESS 1200
#define RST_FILE_TASKS_PROGRESS_MS 50

RST_FileTasksProgressWnd::RST_FileTasksProgressWnd()
  : m_hwnd(NULL)
  , m_per(0)
{}

RST_FileTasksProgressWnd::~RST_FileTasksProgressWnd()
{}

HWND RST_FileTasksProgressWnd::Handle() const
{
  return m_hwnd;
}

WDL_DLGRET RST_FileTasksProgressWnd::ST_FileTasksProgressWndProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam)
{
  RST_FileTasksProgressWnd *self = (RST_FileTasksProgressWnd *)GetWindowLongPtr(hwnd, GWLP_USERDATA);

  if (!self && msg == WM_INITDIALOG)
  {
    SetWindowLongPtr(hwnd, GWLP_USERDATA, lparam);
    self = (RST_FileTasksProgressWnd *)lparam;
    self->m_hwnd = hwnd;
  }

  if (WDL_likely(self))
  {
    return self->FileTasksProgressWndProc(msg, wparam, lparam);
  }
  else
  {
    return 0;
  }
}

void RST_FileTasksProgressWnd::OnInitDialog(WPARAM wparam, LPARAM lparam)
{
  int x, y;
  x = g_ini_file->read_int("file_prog_wnd_x", 0, TERPSICHORE_NAME);
  y = g_ini_file->read_int("file_prog_wnd_y", 50, TERPSICHORE_NAME);
  SetWindowPos(m_hwnd, NULL, x, y, 0, 0, SWP_NOSIZE | SWP_NOZORDER | SWP_NOACTIVATE);

  SetTimer(m_hwnd, RST_FILE_TASKS_PROGRESS, RST_FILE_TASKS_PROGRESS_MS, NULL);
}

void RST_FileTasksProgressWnd::OnDestroy(WPARAM wparam, LPARAM lparam)
{
  RECT r;
  GetWindowRect(m_hwnd, &r);
  g_ini_file->write_int("file_prog_wnd_x", r.left, TERPSICHORE_NAME);
  g_ini_file->write_int("file_prog_wnd_y", r.top, TERPSICHORE_NAME);

  KillTimer(m_hwnd, RST_FILE_TASKS_PROGRESS);

  m_per = 0;
  m_hwnd = NULL;
}

void RST_FileTasksProgressWnd::OnTimer(WPARAM wparam, LPARAM lparam)
{
  if (wparam == RST_FILE_TASKS_PROGRESS)
  {
    RST_FileTasks *ft = g_main_wnd->FileTask();
    int idx = ft->CurrentIndex() + 1;
    int tot = ft->TotalFiles();
    int per = (tot > 0) ? (idx * 100) / tot : 0;

    if (m_per < per) m_per = per;

    SetWindowText(GetDlgItem(m_hwnd, IDC_STATIC1), ft->FileInProgress());
    SendMessage(GetDlgItem(m_hwnd, IDC_PROGRESS1), PBM_SETRANGE, 0, MAKELPARAM(0, 100));

    if (m_per)
    {
      SendMessage(GetDlgItem(m_hwnd, IDC_PROGRESS1), PBM_SETPOS, m_per, 0);
    }
  }
}

void RST_FileTasksProgressWnd::OnCommand(WPARAM wparam, LPARAM lparam)
{
  switch(LOWORD(wparam))
  {
  case IDCANCEL:
    {
      g_main_wnd->FileTask()->AbortOperation();
    }
    break;
  }
}

WDL_DLGRET RST_FileTasksProgressWnd::FileTasksProgressWndProc(UINT msg, WPARAM wparam, LPARAM lparam)
{
  switch (msg)
  {
    case WM_INITDIALOG: OnInitDialog(wparam, lparam); break;
    case WM_DESTROY: OnDestroy(wparam, lparam); break;
    case WM_TIMER: OnTimer(wparam, lparam); break;
    case WM_COMMAND: OnCommand(wparam, lparam); break;
  }

  return 0;
}
