// Copyright (c) 2019 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _TERPSICHORE_FILE_TASKS_H_
#define _TERPSICHORE_FILE_TASKS_H_

#include "terpsichore/definitions.h"
#include "terpsichore/playlist_wnd.h"
#include "WDL/mutex.h"
#include "WDL/ptrlist.h"
#include "WDL/wdlstring.h"
#include "WDL/filebrowse.h"
#include "WDL/dirscan.h"
#include "WDL/lineparse.h"

class RST_FileTasks
{
public:
  RST_FileTasks();
  ~RST_FileTasks();

  void SetParent(HWND parent);

  void OpenFolder();
  void OpenFiles();
  void AddFolder();
  void AddFiles();

  void LoadPlayList();
  void SavePlayList();

  bool WantProgressWindow() const;
  const char *FileInProgress() const;
  int CurrentIndex() const;
  int TotalFiles() const;
  void AbortOperation();

private:
  int Run();
  void OnOpenFolder();
  void OnOpenFiles();
  void OnAddFolder();
  void OnAddFiles();
  void OnLoadPlayList();
  void OnSavePlayList();
  void StartThread();
  void StopThread();
  void ScanFiles(const char *path, bool empty_buffer = true);
  static unsigned int WINAPI ThreadFunction(void *arg);
  void EmptyFileCache();
  void WantProgress();

  HWND m_hwnd;

  bool m_open_folder;
  bool m_open_files;
  bool m_add_folder;
  bool m_add_files;
  bool m_load_pl;
  bool m_save_pl;

  LineParser m_lp;

  WDL_PtrList<WDL_FastString> m_file_cache;

  HANDLE m_thread;
  bool m_kill_thread;
  WDL_Mutex m_mutex;

  bool m_want_progress;
  bool m_scanning;
  bool m_cancel;

  WDL_FastString *m_curfn;
  int m_idx;

  char *m_selfiles;
  WDL_TypedBuf<char> m_selected_dir;
};

#endif // _TERPSICHORE_FILE_TASKS_H_
