// Copyright (c) 2020 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _TERPSICHORE_FIND_WINDOW_H_
#define _TERPSICHORE_FIND_WINDOW_H_

#include "terpsichore/definitions.h"

#include "WDL/wingui/wndsize.h"
#include "WDL/heapbuf.h"

class RST_FindWnd
{
public:
  RST_FindWnd();
  ~RST_FindWnd();

  HWND Handle() const;

  static WDL_DLGRET ST_FindWndProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam);

private:
  WDL_DLGRET FindWndProc(UINT msg, WPARAM wparam, LPARAM lparam);
  void OnInitDialog(WPARAM wparam, LPARAM lparam);
  void OnTimer(WPARAM wparam, LPARAM lparam);
  void OnDestroy(WPARAM wparam, LPARAM lparam);
  void OnCommand(WPARAM wparam, LPARAM lparam);

  HWND m_hwnd;
  HWND m_edit;

  WDL_TypedBuf<int> m_selected_items;
  int m_focused_item;

  int m_last_query;
};

#endif // _TERPSICHORE_FIND_WINDOW_H_
