// Copyright (c) 2019 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#include "terpsichore/icon_theme.h"
#include "terpsichore/definitions.h"

RST_IconTheme::RST_IconTheme()
  : img_gen_thumb_horz(NULL)
  , img_repeat(NULL)
  , img_repeat_on(NULL)
  , img_shuffle(NULL)
  , img_shuffle_on(NULL)
  , img_pause(NULL)
  , img_pause_on(NULL)
  , img_previous(NULL)
  , img_next(NULL)
  , img_play(NULL)
  , img_play_on(NULL)
  , img_stop(NULL)
{}

RST_IconTheme::~RST_IconTheme()
{
  UnloadImages();
}

void RST_IconTheme::LoadImages()
{
  WDL_HeapBuf *buf;

  buf = g_theme->data.Get("gen_thumb_horz.png");

  if (buf)
  {
    img_gen_thumb_horz = LICE_LoadPNGFromMemory(
      buf->Get(), buf->GetSize());

    ts_progress.thumbimage[0] = img_gen_thumb_horz;
    ts_progress.thumbimage[1] = img_gen_thumb_horz;
    WDL_VirtualSlider_PreprocessSkinConfig(&ts_progress);

    ts_volume.thumbimage[0] = img_gen_thumb_horz;
    ts_volume.thumbimage[1] = img_gen_thumb_horz;
    WDL_VirtualSlider_PreprocessSkinConfig(&ts_volume);
  }

  buf = g_theme->data.Get("repeat.png");

  if (buf)
  {
    img_repeat = LICE_LoadPNGFromMemory(
      buf->Get(), buf->GetSize());

    ts_repeat.image = img_repeat;
    ts_repeat.image_issingle = false;
    WDL_VirtualIconButton_PreprocessSkinConfig(&ts_repeat);
  }

  buf = g_theme->data.Get("repeat_on.png");

  if (buf)
  {
    img_repeat_on = LICE_LoadPNGFromMemory(
      buf->Get(), buf->GetSize());

    ts_repeat_on.image = img_repeat_on;
    ts_repeat_on.image_issingle = false;
    WDL_VirtualIconButton_PreprocessSkinConfig(&ts_repeat_on);
  }

  buf = g_theme->data.Get("shuffle.png");

  if (buf)
  {
    img_shuffle = LICE_LoadPNGFromMemory(
      buf->Get(), buf->GetSize());

    ts_shuffle.image = img_shuffle;
    ts_shuffle.image_issingle = false;
    WDL_VirtualIconButton_PreprocessSkinConfig(&ts_shuffle);
  }

  buf = g_theme->data.Get("shuffle_on.png");

  if (buf)
  {
    img_shuffle_on = LICE_LoadPNGFromMemory(
      buf->Get(), buf->GetSize());

    ts_shuffle_on.image = img_shuffle_on;
    ts_shuffle_on.image_issingle = false;
    WDL_VirtualIconButton_PreprocessSkinConfig(&ts_shuffle_on);
  }

  buf = g_theme->data.Get("pause.png");

  if (buf)
  {
    img_pause = LICE_LoadPNGFromMemory(
      buf->Get(), buf->GetSize());

    ts_pause.image = img_pause;
    ts_pause.image_issingle = false;
    WDL_VirtualIconButton_PreprocessSkinConfig(&ts_pause);
  }

  buf = g_theme->data.Get("pause_on.png");

  if (buf)
  {
    img_pause_on = LICE_LoadPNGFromMemory(
      buf->Get(), buf->GetSize());

    ts_pause_on.image = img_pause_on;
    ts_pause_on.image_issingle = false;
    WDL_VirtualIconButton_PreprocessSkinConfig(&ts_pause_on);
  }

  buf = g_theme->data.Get("previous.png");

  if (buf)
  {
    img_previous = LICE_LoadPNGFromMemory(
      buf->Get(), buf->GetSize());

    ts_previous.image = img_previous;
    ts_previous.image_issingle = false;
    WDL_VirtualIconButton_PreprocessSkinConfig(&ts_previous);
  }

  buf = g_theme->data.Get("next.png");

  if (buf)
  {
    img_next = LICE_LoadPNGFromMemory(
      buf->Get(), buf->GetSize());

    ts_next.image = img_next;
    ts_next.image_issingle = false;
    WDL_VirtualIconButton_PreprocessSkinConfig(&ts_next);
  }

  buf = g_theme->data.Get("play.png");

  if (buf)
  {
    img_play = LICE_LoadPNGFromMemory(
      buf->Get(), buf->GetSize());

    ts_play.image = img_play;
    ts_play.image_issingle = false;
    WDL_VirtualIconButton_PreprocessSkinConfig(&ts_play);
  }

  buf = g_theme->data.Get("play_on.png");

  if (buf)
  {
    img_play_on = LICE_LoadPNGFromMemory(
      buf->Get(), buf->GetSize());

    ts_play_on.image = img_play_on;
    ts_play_on.image_issingle = false;
    WDL_VirtualIconButton_PreprocessSkinConfig(&ts_play_on);
  }

  buf = g_theme->data.Get("stop.png");

  if (buf)
  {
    img_stop = LICE_LoadPNGFromMemory(
      buf->Get(), buf->GetSize());

    ts_stop.image = img_stop;
    ts_stop.image_issingle = false;
    WDL_VirtualIconButton_PreprocessSkinConfig(&ts_stop);
  }
}

void RST_IconTheme::UnloadImages()
{
  if (img_gen_thumb_horz) { delete img_gen_thumb_horz; img_gen_thumb_horz = NULL; }
  if (img_repeat) { delete img_repeat; img_repeat = NULL; }
  if (img_repeat_on) { delete img_repeat_on; img_repeat_on = NULL; }
  if (img_shuffle) { delete img_shuffle; img_shuffle = NULL; }
  if (img_shuffle_on) { delete img_shuffle_on; img_shuffle_on = NULL; }
  if (img_pause) { delete img_pause; img_pause = NULL; }
  if (img_pause_on) { delete img_pause_on; img_pause_on = NULL; }
  if (img_previous) { delete img_previous; img_previous = NULL; }
  if (img_next) { delete img_next; img_next = NULL; }
  if (img_play) { delete img_play; img_play = NULL; }
  if (img_play_on) { delete img_play_on; img_play_on = NULL; }
  if (img_stop) { delete img_stop; img_stop = NULL; }
}
