// Copyright (c) 2017 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#include "terpsichore/ini_file.h"

#if defined(_WIN32)
  #include <windows.h>
#else
  #include "WDL/swell/swell.h"
  #include "WDL/swell/swell-functions.h"
#endif

RST_IniFile::RST_IniFile(const char *filename)
  : m_filename(filename)
{}

RST_IniFile::~RST_IniFile()
{}

const char *RST_IniFile::read_str(const char *what, const char *def, const char *section)
{
  m_buffer.Resize(2048);

  GetPrivateProfileString(section, what, def, m_buffer.Get(),
    m_buffer.GetSize(), m_filename.Get());

  return m_buffer.Get();
}

int RST_IniFile::read_int(const char *what, int def, const char *section)
{
  return GetPrivateProfileInt(section, what, def, m_filename.Get());
}

void RST_IniFile::write_str(const char *what, const char *value, const char *section)
{
  WritePrivateProfileString(section, what, value, m_filename.Get());
}

void RST_IniFile::write_int(const char *what, int value, const char *section)
{
  WDL_FastString strbuf;
  strbuf.SetFormatted(64, "%d", value);

  WritePrivateProfileString(section, what, strbuf.Get(), m_filename.Get());
}
