// Copyright (c) 2017 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _TERPSICHORE_INI_FILE_H_
#define _TERPSICHORE_INI_FILE_H_

#include <string.h>
#include <stdlib.h>

#include "WDL/wdlstring.h"
#include "WDL/heapbuf.h"

class RST_IniFile
{
public:
  explicit RST_IniFile(const char *filename);

  ~RST_IniFile();

  const char *read_str(const char *what, const char *def, const char *section);

  int read_int(const char *what, int def, const char *section);

  void write_str(const char *what, const char *value, const char *section);

  void write_int(const char *what, int value, const char *section);

private:
  WDL_FastString m_filename;
  WDL_TypedBuf<char> m_buffer;
};

#endif // _TERPSICHORE_INI_FILE_H_
