// Copyright (c) 2019 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _TERPSICHORE_KEYBOARD_MAP_H_
#define _TERPSICHORE_KEYBOARD_MAP_H_

#include <string.h>
#include <stdlib.h>

#include "WDL/assocarray.h"

struct KeyboardHotkey
{
  unsigned char key;
  int ctrl;
  int menu;
  int shift;
  const char *action;
};

class RST_KeyboardMap
{
public:
  RST_KeyboardMap();
  ~RST_KeyboardMap();

  unsigned char GetKey(const char *action);
  bool MatchModifier(const char *action);

private:
  WDL_AssocArray<const char *, const KeyboardHotkey *> m_keymap;
};

#endif // _TERPSICHORE_KEYBOARD_MAP_H_
