// Copyright (c) 2020 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _TERPSICHORE_MAIN_LOOP_H_
#define _TERPSICHORE_MAIN_LOOP_H_

#include "terpsichore/deck.h"
#include "terpsichore/sampler.h"

#include "WDL/ptrlist.h"

class RST_MainLoop
{
public:
  RST_MainLoop();
  ~RST_MainLoop();

  bool IsPlaying() const;
  void LoadDeckA(const char *filepath, int peakrate,
    WDL_StringKeyedArray<double> *ebur128_info);
  void LoadDeckB(const char *filepath, int peakrate,
    WDL_StringKeyedArray<double> *ebur128_info);
  void EjectDeckA();
  void EjectDeckB();

  void PlayDeckA();
  void PlayDeckB();
  void DisablePlayLockDeckA();
  void DisablePlayLockDeckB();

  void ToggleReverseDeckA();
  void ToggleReverseDeckB();

  void SeekBackwardDeckA();
  void SeekForwardDeckA();
  void SeekBackwardDeckB();
  void SeekForwardDeckB();

  void RewindDeckA(bool state);
  void FastForwardDeckA(bool state);
  void RewindDeckB(bool state);
  void FastForwardDeckB(bool state);

  void SetStateDeckA(bool state);
  void SetStateDeckB(bool state);

  bool IsActiveDeckA() const;
  bool IsActiveDeckB() const;

  double GetRunTimeDeckA() const;
  double GetRunTimeDeckB() const;
  double GetDurationDeckA() const;
  double GetDurationDeckB() const;
  double GetCueDeckA() const;
  double GetCueDeckB() const;
  WDL_IntKeyedArray<double> *GetHotCueDeckA() const;
  WDL_IntKeyedArray<double> *GetHotCueDeckB() const;
  double GetFaderDecibelDeckA() const;
  double GetFaderDecibelDeckB() const;

  const char *GetTitleDeckA() const;
  const char *GetTitleDeckB() const;
  const char *GetArtistDeckA() const;
  const char *GetArtistDeckB() const;

  bool IsPlayActiveDeckA() const;
  bool IsPlayActiveDeckB() const;

  void DecreaseShiftDeckA();
  void DecreaseShiftDeckB();
  void IncreaseShiftDeckA();
  void IncreaseShiftDeckB();
  void DecreaseShiftSmallDeckA();
  void DecreaseShiftSmallDeckB();
  void IncreaseShiftSmallDeckA();
  void IncreaseShiftSmallDeckB();
  void DecreaseTempoDeckA();
  void DecreaseTempoDeckB();
  void IncreaseTempoDeckA();
  void IncreaseTempoDeckB();
  void DecreaseTempoSmallDeckA();
  void DecreaseTempoSmallDeckB();
  void IncreaseTempoSmallDeckA();
  void IncreaseTempoSmallDeckB();
  void ResetShiftDeckA();
  void ResetShiftDeckB();
  void ResetTempoDeckA();
  void ResetTempoDeckB();

  void EnableCueDeckA();
  void EnableCueDeckB();
  void SetCueDeckA();
  void SetCueDeckB();
  void EnableHotCueDeckA(int idx);
  void EnableHotCueDeckB(int idx);
  void ClearHotCueDeckA(int idx);
  void ClearHotCueDeckB(int idx);
  void DisableCueDeckA();
  void DisableCueDeckB();
  void DisableHotCueDeckA(int idx);
  void DisableHotCueDeckB(int idx);

  double GetFaderDeckA() const;
  double GetFaderDeckB() const;
  void SetFaderDeckA(double percentage);
  void SetFaderDeckB(double percentage);

  void SetKillRegion(WDL_HeapBuf *kill_region);
  void GetKillRegion(WDL_HeapBuf **kill_region);

  RST_Deck *GetDeckA() const { return m_decks.Get(0); }
  RST_Deck *GetDeckB() const { return m_decks.Get(1); }

  int Run();
  void AudioOutput(WDL_TypedBuf<SAM> *output, int frame_count, int nch);

private:
  WDL_PtrList<RST_Deck> m_decks;
  WDL_PtrList<RST_Sampler> m_samplers;

  WDL_HeapBuf *m_kill_region;
  bool m_play_lock_deck_a;
  bool m_play_lock_deck_b;
};

#endif // _TERPSICHORE_MAIN_LOOP_H_
