// Copyright (c) 2017 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

//#define ENABLE_TERPSICHORE_CONSOLE

#include <shlobj.h>

#include "terpsichore/definitions.h"
#include "terpsichore/main_wnd.h"
#include "terpsichore/definitions.h"
#include "terpsichore/app_info.h"
#include "terpsichore/plugin.h"

#if defined(_WIN32) && defined(_DEBUG)
#include <vld.h>
#endif

#include "WDL/win32_curses/curses.h"
#include "WDL/wingui/virtwnd.h"
#include "WDL/dirscan.h"
#include "WDL/lineparse.h"

int WINAPI WinMain(_In_ HINSTANCE instance,
  _In_opt_ HINSTANCE previous_instance,
  _In_ LPSTR cmd_param, _In_ int show_cmd)
{
  g_inst = instance;

  CoInitialize(NULL);
  //CoInitializeEx(NULL, ); // COINIT_APARTMENTTHREADED, COINIT_MULTITHREADED

  InitCommonControls();
  //LoadLibrary("riched20.dll");

  g_scroll_message = RegisterWindowMessage("MSWHEEL_ROLLMSG");

  {
    LineParser lp;
    lp.parse(cmd_param);

    for (int i = 0; i < lp.getnumtokens(); i++)
    {
      if (!strcmp(lp.gettoken_str(i), "--sleep"))
      {
        Sleep(888);
      }
    }
  }


  HWND other_alive = FindWindowEx(NULL, NULL, "terpsichore_superhost", NULL);

  if (other_alive)
  {
    SetForegroundWindow(other_alive);

    return 0;
  }

#if defined(_WIN32) && defined(_DEBUG) && defined(ENABLE_TERPSICHORE_CONSOLE)
  // The first will use the console only if
  // the application is started by the command 
  // line. The second one will always enable
  // the console.
  //if (AttachConsole(ATTACH_PARENT_PROCESS))
  if (AttachConsole(ATTACH_PARENT_PROCESS) || AllocConsole())
  {
      freopen("CONOUT$", "w", stdout);
      freopen("CONOUT$", "w", stderr);
  }
#endif

  HICON icon = LoadIcon(g_inst, MAKEINTRESOURCE(IDI_ICON1));

  {
    WNDCLASS wc = { 0 };
    GetClassInfo(NULL, "#32770", &wc);
    wc.hCursor = LoadCursor(NULL, IDC_ARROW);
    wc.hIcon = icon;
    wc.hInstance = g_inst;
    RegisterClass(&wc);

    //wc.style = CS_HREDRAW | CS_VREDRAW;
    //wc.style = CS_GLOBALCLASS;
    wc.style = CS_DBLCLKS;
    wc.lpszClassName = "terpsichore_superhost";
    RegisterClass(&wc);

    //wc.style = CS_GLOBALCLASS;
    //wc.lpfnWndProc = (WNDPROC)main_draw_proc;
    //wc.hCursor = LoadCursor(NULL, IDC_ARROW);
    //wc.lpszClassName = "maindraw_superhost";
    //RegisterClass(&wc);

    wc.lpszClassName = "preferences_superhost";
    RegisterClass(&wc);

    wc.lpszClassName = "device_superhost";
    RegisterClass(&wc);

    wc.lpszClassName = "playlist_superhost";
    RegisterClass(&wc);

    wc.lpszClassName = "about_superhost";
    RegisterClass(&wc);

    wc.lpszClassName = "license_superhost";
    RegisterClass(&wc);

    wc.lpszClassName = "changelog_superhost";
    RegisterClass(&wc);

    wc.lpszClassName = "preview_artwork_superhost";
    RegisterClass(&wc);

    wc.lpszClassName = "file_tasks_superhost";
    RegisterClass(&wc);

    wc.lpszClassName = "find_superhost";
    RegisterClass(&wc);

    wc.lpszClassName = "exact_volume_superhost";
    RegisterClass(&wc);

    wc.lpszClassName = "properties_superhost";
    RegisterClass(&wc);

    wc.lpszClassName = "load_superhost";
    RegisterClass(&wc);

    curses_registerChildClass(g_inst);

    //wc.lpfnWndProc = (WNDPROC)custom_playlist_control_proc;
    //wc.hCursor = LoadCursor(NULL, IDC_ARROW);
    //wc.lpszClassName = "playlist_control_superhost";
    //RegisterClass(&wc);
  }

  char module_filename[2048];
  GetModuleFileName(g_inst, module_filename, sizeof(module_filename));

  g_module_path.Set(module_filename);
  g_module_path.remove_filepart(true);

  bool portable_settings = false;

  // In order to have portable settings
  // create an empty directory with the
  // name |portable| in the root directory
  // of Terpsichore.

  if (!portable_settings)
  {
    WDL_DirScan dir;
    WDL_FastString fn;

    if (!dir.First(g_module_path.Get()))
    {
      do
      {
        if (dir.GetCurrentIsDirectory())
        {
          dir.GetCurrentFullFN(&fn);

          if (strcmp(fn.get_filepart(), "portable") == 0)
          {
            portable_settings = true;
            break;
          }
        }
      }
      while (!dir.Next());
    }
  }

  if (portable_settings)
  {
    g_settings_path.Set(g_module_path.Get());
    g_settings_path.Append("portable");
    g_settings_path.Append(WDL_DIRCHAR_STR);
  }
  else
  {
    char user_path[2048];

    // CSIDL_APPDATA to get the equivalent of %APPDATA%
    // CSIDL_PROFILE to get the equivalent of %USERPROFILE%
    if (SHGetSpecialFolderPathUTF8(NULL, user_path, sizeof(user_path), CSIDL_APPDATA, 0))
    {
      g_settings_path.Set(user_path);
      g_settings_path.Append("\\" TERPSICHORE_NAME_MARKETING "\\");
      CreateDirectory(g_settings_path.Get(), NULL);
    }
    else
    {
      MessageBox(NULL, "Terpsichore cannot retrieve user's roaming directory. Press OK to exit Terpsichore.", "Terpsichore error", MB_OK);
      exit(1);
    }
  }

  g_ini_path.Set(g_settings_path.Get());
  g_ini_path.Append(TERPSICHORE_NAME);
  g_ini_path.Append(".ini");

  // Start sub-systems
  g_ini_file = new RST_IniFile(g_ini_path.Get());

  LoadPlugins();

  g_main_wnd = new RST_MainWnd;

  CreateDialogParam(g_inst, MAKEINTRESOURCE(IDD_MAIN), GetDesktopWindow(),
    RST_MainWnd::ST_MainWndProc, (LPARAM)g_main_wnd);

  g_main_wnd->RunMessageLoop();

  delete g_main_wnd;

  delete g_ini_file;

  ReleasePlugins();

  CoUninitialize();

  return 0;
}
