// Copyright (c) 2019 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _TERPSICHORE_MAIN_WINDOW_H_
#define _TERPSICHORE_MAIN_WINDOW_H_

#include "terpsichore/definitions.h"
#include "terpsichore/playlist_wnd.h"
#include "terpsichore/decks_wnd.h"
#include "terpsichore/preferences_wnd.h"
#include "terpsichore/find_wnd.h"
#include "terpsichore/license_wnd.h"
#include "terpsichore/about_wnd.h"
#include "terpsichore/changelog_wnd.h"
#include "terpsichore/file_tasks.h"
#include "terpsichore/file_prog_wnd.h"
#include "terpsichore/exactvol_wnd.h"

#include "WDL/win32_utf8.h"
#include "WDL/wingui/wndsize.h"
#include "WDL/lineparse.h"
#include "WDL/mutex.h"

class RST_MainWnd
{
public:
  RST_MainWnd();
  ~RST_MainWnd();

  HWND Handle() const;

  void ShowPlayList();
  void ShowKillRegionInfo(const char *info);

  RST_FileTasks *FileTask();

  bool IsEngineOnline() const;
  void SetEngineOnline();
  void SetEngineOffline();

  void RunMessageLoop();
  int ProcessMessage(MSG *msg);

  void SetColor(int bg, int fg);

  static WDL_DLGRET ST_MainWndProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam);

private:
  WDL_DLGRET MainWndProc(UINT msg, WPARAM wparam, LPARAM lparam);
  void OnInitDialog(WPARAM wparam, LPARAM lparam);
  void OnTimer(WPARAM wparam, LPARAM lparam);
  void OnNCLButtonDown(WPARAM wparam, LPARAM lparam);
  int OnActivateApp(WPARAM wparam, LPARAM lparam);
  void OnSysCommand(WPARAM wparam, LPARAM lparam);
  int OnClose(WPARAM wparam, LPARAM lparam);
  void OnPaint(WPARAM wparam, LPARAM lparam);
  void OnSize(WPARAM wparam, LPARAM lparam);
  void OnMove(WPARAM wparam, LPARAM lparam);
  int OnDestroy(WPARAM wparam, LPARAM lparam);
  void OnCommand(WPARAM wparam, LPARAM lparam);

  HWND m_hwnd;
  HMENU m_main_menu;
  WDL_WndSizer m_resize;
  WDL_Mutex m_mutex;
  bool m_title_capture;

  int m_x, m_y, m_w, m_h;

  WDL_VWnd_Painter m_painter;
  RST_PlayListWnd m_pl_wnd;
  RST_DecksWnd m_decks_wnd;

  RST_PreferencesWnd m_pr_wnd;
  RST_FindWnd m_find_wnd;

  RST_LicenseWnd m_lic_wnd;
  RST_AboutWnd m_about_wnd;
  RST_ChangeLogWnd m_cl_wnd;

  RST_FileTasks m_file_task;
  RST_FileTasksProgressWnd m_ft_prog_wnd;
  WDL_FastString m_titstr;

  int m_cut_copy_paste_ms;
  WDL_FastString m_cut_copy_paste_info;

  RST_ExactVolWnd m_exactvol_wnd;

  int m_bgc;
  int m_txtc;
};

#endif // _TERPSICHORE_MAIN_WINDOW_H_
