// Copyright (c) 2021 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _TERPSICHORE_FFMPEG_PEAKS_H_
#define _TERPSICHORE_FFMPEG_PEAKS_H_

#ifdef _WIN32
#include <windows.h>
#include <process.h>
#else
#include "WDL/swell/swell.h"
#endif

#include "terpsichore/terpsichore_plugin.h"

#include "WDL/mutex.h"
#include "WDL/fileread.h"
#include "WDL/wdlstring.h"

class RST_Peaks
{
public:
  RST_Peaks();
  ~RST_Peaks();

  bool Open(const char *filename);
  int GetPeaks(short *buffer, int length);
  void Seek(double time);
  WDL_INT64 GetNumPeaks();
  bool ArePeaksReady() const;
private:
  static unsigned int WINAPI ThreadFunction(void *arg);
  int WritePeaks();

  HANDLE m_thread;
  bool m_kill_thread;
  WDL_Mutex m_mutex;

  WDL_FastString m_fn;
  WDL_FileRead *m_fr;
  int m_peakspersec;
  bool m_peaksready;
};

#endif // _TERPSICHORE_FFMPEG_PEAKS_H_
