// Copyright (c) 2019 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _TERPSICHORE_PLAYLIST_WINDOW_H_
#define _TERPSICHORE_PLAYLIST_WINDOW_H_

#include "terpsichore/definitions.h"
#include "terpsichore/properties_wnd.h"
#include "terpsichore/preview_artwork_wnd.h"

#include "WDL/MersenneTwister.h"
#include "WDL/wingui/wndsize.h"
#include "WDL/heapbuf.h"
#include "WDL/assocarray.h"
#include "WDL/ptrlist.h"
#include "WDL/lineparse.h"

class RST_PlayListWnd
{
public:
  RST_PlayListWnd();
  ~RST_PlayListWnd();

  HWND Handle() const;
  HWND PropertiesHandle() const;
  HWND PreviewHandle() const;
  bool SavePlayList(const char *fn);
  bool LoadPlayList(const char *fn);
  void RemoveAll();
  void SelectAll();
  void SelectNone();
  void InvertSelection();
  void AddItem(const char *filename);
  int Find(const char *str);
  void PreviousFind();
  void NextFind();
  void InfoFind(int *current, int *total, int *pl_index);
  void MarkFind();
  void GetSelected(WDL_TypedBuf<int> *items, int *focus);
  void SetSelection(WDL_TypedBuf<int> *items, int focus);
  void SortMenu();
  void Reverse();
  void Randomize();
  void Sort(int column);
  void RemoveSelected();
  void CropSelected();
  void RemoveMissingFiles();
  void RemoveDuplicateEntries();
  void MoveUp();
  void MoveDown();
  void CutTracks();
  void CopyTracks();
  void PasteTracks();
  void OpenFileLocation();
  void ApplyListViewColors(int bgc, int txtc);

  void Play(int track_num = -1);

  void LoadDeckA();
  void LoadDeckB();

  static WDL_DLGRET ST_PlayListWndProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam);

private:
  static int CALLBACK ListViewCompareProc(LPARAM lparam1, LPARAM lparam2, LPARAM lparam_sort);
  WDL_DLGRET PlayListWndProc(UINT msg, WPARAM wparam, LPARAM lparam);
  static WDL_DLGRET NewListProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam);
  void ScanFiles(const char *path, bool empty_buffer);
  void MoveTracks(int new_pos);
  void OnInitDialog(WPARAM wparam, LPARAM lparam);
  void OnDestroy(WPARAM wparam, LPARAM lparam);
  void OnDropFiles(WPARAM wparam, LPARAM lparam);
  void OnSize(WPARAM wparam, LPARAM lparam);
  void OnPaint(WPARAM wparam, LPARAM lparam);
  void OnCommand(WPARAM wparam, LPARAM lparam);
  void OnContextMenu(WPARAM wparam, LPARAM lparam);
  void OnNotify(WPARAM wparam, LPARAM lparam);
  void OnMouseMove(WPARAM wparam, LPARAM lparam);
  int OnLButtonUp(WPARAM wparam, LPARAM lparam);

  int DoCompare(char *s1, char *s2);
  void UpdatePlayListData();
  void UpdatePlayListIndex();
  WDL_HeapBuf *CopySelectedTracks();
  void Properties();
  void PreviewArtwork();

  struct ColumnHeader
  {
    int id;
    const char *text;
    int width;
    int fmt;
    int sort_dir; // 1 ascending, -1 descending
    int sort_type; // 0 text, 1 numeric
  };

  HWND m_hwnd;

  WDL_TypedBuf<int> m_found;
  int m_cycle_found;
  //WDL_VWnd_Painter m_painter;
  WDL_WndSizer m_resize;
  HWND m_list;
  int m_column; // Set the desired column before you call PL_Sort()
  HDROP m_drop;
  MTRand m_mt;

  WDL_TypedBuf<ColumnHeader> m_column_header;
  HMENU m_context_menu;
  HMENU m_column_menu;
  HMENU m_sort_menu;

  //LVHITTESTINFO m_ht;
  bool m_drag_started;

  LineParser m_lp;
  WDL_PtrList<WDL_FastString> m_files;

  RST_PropertiesWnd m_prop_wnd;
  RST_PreviewArtworkWnd m_prevart_wnd;
};

#endif // _TERPSICHORE_PLAYLIST_WINDOW_H_
