// Copyright (c) 2019 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _TERPSICHORE_MODULE_CREATION_H_
#define _TERPSICHORE_MODULE_CREATION_H_

#include "terpsichore/definitions.h"
#include "terpsichore/terpsichore_plugin.h"

RST_IFileInput *CreateAudioInput(const char *filename);
RST_IFileTagger *CreateFileTagger(const char *filename);
RST_IFilePic *CreateFilePic(const char *filename);
RST_IAudioStreamer *CreateAudioStreamer(const char *name);
RST_IAudioStreamerDevice *CreateAudioStreamerDevice(const char *name);
RST_IAudioStreamerProperties *CreateAudioStreamerProperties(const char *name);
RST_IPitchShift *CreatePitchShift(const char *name);

void LoadPlugins();
void ReleasePlugins();

#endif // _TERPSICHORE_MODULE_CREATION_H_
