// Copyright (c) 2022 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#include "terpsichore/pr_psts_wnd.h"
#include "terpsichore/main_wnd.h"

#include "WDL/win32_utf8.h"
#include "WDL/wdlstring.h"
#include "WDL/heapbuf.h"

RST_PSTSWnd::RST_PSTSWnd()
  : m_hwnd(NULL)
{}

RST_PSTSWnd::~RST_PSTSWnd()
{}

HWND RST_PSTSWnd::Handle() const
{
  return m_hwnd;
}

WDL_DLGRET RST_PSTSWnd::ST_PSTSWndProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam)
{
  RST_PSTSWnd *self = (RST_PSTSWnd *)GetWindowLongPtr(hwnd, GWLP_USERDATA);

  if (!self && msg == WM_INITDIALOG)
  {
    SetWindowLongPtr(hwnd, GWLP_USERDATA, lparam);
    self = (RST_PSTSWnd *)lparam;
    self->m_hwnd = hwnd;
  }

  if (WDL_likely(self))
  {
    return self->PSTSWndProc(msg, wparam, lparam);
  }
  else
  {
    return 0;
  }
}

void RST_PSTSWnd::OnInitDialog(WPARAM wparam, LPARAM lparam)
{
  int psstep = g_ini_file->read_int("pitch_shift_step", 100, "preferences");
  int tsstep = g_ini_file->read_int("time_stretch_step", 100, "preferences");
  int psaltstep = g_ini_file->read_int("pitch_shift_altstep", 10, "preferences");
  int tsaltstep = g_ini_file->read_int("time_stretch_altstep", 10, "preferences");

  WDL_FastString strbuf;
  strbuf.SetFormatted(128, "%d", psstep);
  SetWindowText(GetDlgItem(m_hwnd, IDC_EDIT1), strbuf.Get());
  strbuf.SetFormatted(128, "%d", tsstep);
  SetWindowText(GetDlgItem(m_hwnd, IDC_EDIT2), strbuf.Get());
  strbuf.SetFormatted(128, "%d", psaltstep);
  SetWindowText(GetDlgItem(m_hwnd, IDC_EDIT4), strbuf.Get());
  strbuf.SetFormatted(128, "%d", tsaltstep);
  SetWindowText(GetDlgItem(m_hwnd, IDC_EDIT5), strbuf.Get());
}

void RST_PSTSWnd::OnDestroy(WPARAM wparam, LPARAM lparam)
{
  m_hwnd = NULL;
}

void RST_PSTSWnd::OnCommand(WPARAM wparam, LPARAM lparam)
{
  switch(LOWORD(wparam))
  {
  case IDC_EDIT1:
    if (HIWORD(wparam) == EN_CHANGE)
    {
      BOOL ok;
      int val = GetDlgItemInt(m_hwnd, IDC_EDIT1, &ok, TRUE);
      g_preference_settings->Set("pitch_shift_step", val);
    }
    break;
  case IDC_EDIT2:
    if (HIWORD(wparam) == EN_CHANGE)
    {
      BOOL ok;
      int val = GetDlgItemInt(m_hwnd, IDC_EDIT2, &ok, TRUE);
      g_preference_settings->Set("time_stretch_step", val);
    }
    break;
  case IDC_EDIT4:
    if (HIWORD(wparam) == EN_CHANGE)
    {
      BOOL ok;
      int val = GetDlgItemInt(m_hwnd, IDC_EDIT4, &ok, TRUE);
      g_preference_settings->Set("pitch_shift_altstep", val);
    }
    break;
  case IDC_EDIT5:
    if (HIWORD(wparam) == EN_CHANGE)
    {
      BOOL ok;
      int val = GetDlgItemInt(m_hwnd, IDC_EDIT5, &ok, TRUE);
      g_preference_settings->Set("time_stretch_altstep", val);
    }
    break;
  }
}

WDL_DLGRET RST_PSTSWnd::PSTSWndProc(UINT msg, WPARAM wparam, LPARAM lparam)
{
  switch(msg)
  {
    case WM_INITDIALOG: OnInitDialog(wparam, lparam); break;
    case WM_DESTROY: OnDestroy(wparam, lparam); break;
    case WM_COMMAND: OnCommand(wparam, lparam); break;
  }

  return 0;
}
