// Copyright (c) 2019 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _TERPSICHORE_PREFERENCES_WINDOW_H_
#define _TERPSICHORE_PREFERENCES_WINDOW_H_

#include "terpsichore/definitions.h"
#include "terpsichore/pr_general_wnd.h"
#include "terpsichore/pr_disk_io_wnd.h"
#include "terpsichore/pr_ebur128_wnd.h"
#include "terpsichore/pr_psts_wnd.h"
#include "terpsichore/pr_media_library_wnd.h"
#include "terpsichore/pr_audio_system_wnd.h"

class RST_PreferencesWnd
{
public:
  RST_PreferencesWnd();
  ~RST_PreferencesWnd();

  HWND Handle() const;

  static WDL_DLGRET ST_PreferencesWndProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam);

private:
  WDL_DLGRET PreferencesWndProc(UINT msg, WPARAM wparam, LPARAM lparam);
  HTREEITEM AddItem(HWND hwnd, HTREEITEM h, const char *str, int children, int data);
  void OnInitDialog(WPARAM wparam, LPARAM lparam);
  void OnTimer(WPARAM wparam, LPARAM lparam);
  void OnDestroy(WPARAM wparam, LPARAM lparam);
  void OnSysCommand(WPARAM wparam, LPARAM lparam);
  void OnNotify(WPARAM wparam, LPARAM lparam);
  void OnCommand(WPARAM wparam, LPARAM lparam);

  HWND m_hwnd;
  int m_last_page;
  HTREEITEM m_last_page_item;
  HWND m_current_window;
  RST_IAudioStreamerProperties *m_hw_prop;

  RST_GeneralWnd m_gen_wnd;
  RST_DiskIOWnd m_diskio_wnd;
  RST_EBUR128Wnd m_ebur128_wnd;
  RST_PSTSWnd m_psts_wnd;
  RST_MediaLibraryWnd m_ml_wnd;
  RST_AudioSystemWnd m_audio_system_wnd;
};

#endif // _TERPSICHORE_PREFERENCES_WINDOW_H_
