// Copyright (c) 2020 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _TERPSICHORE_PREVIEW_ARTWORK_WINDOW_H_
#define _TERPSICHORE_PREVIEW_ARTWORK_WINDOW_H_

#include "terpsichore/definitions.h"

#include "WDL/lice/lice.h"
#include "WDL/lice/lice_text.h"
#include "WDL/wingui/scrollbar/coolscroll.h"
#include "WDL/wingui/wndsize.h"
#include "WDL/wingui/virtwnd.h"
#include "WDL/mutex.h"

class RST_SingleImage : public WDL_VWnd
{
public:
  RST_SingleImage();
  ~RST_SingleImage();

  void OnPaint(LICE_IBitmap *drawbm, int origin_x, int origin_y, RECT *cliprect, int rscale);
  int OnMouseDown(int xpos, int ypos);
  void OnMouseUp(int xpos, int ypos);

  LICE_IBitmap *m_img;
  LICE_IFont *m_font;
  int m_track;
  WDL_FastString m_fn;
  bool m_blur;
};

class RST_PreviewArtworkWnd
{
public:
  RST_PreviewArtworkWnd();
  ~RST_PreviewArtworkWnd();

  HWND Handle() const;

  void PreviewArtwork(WDL_PtrList<char> *files, WDL_TypedBuf<int> *track, HWND parent);

  static WDL_DLGRET ST_PreviewArtworkWndProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam);
private:
  WDL_DLGRET PreviewArtworkWndProc(UINT msg, WPARAM wparam, LPARAM lparam);
  static unsigned int WINAPI ThreadFunction(void *arg);
  int Run();
  int OrganizeWindow();
  void OnInitDialog(WPARAM wparam, LPARAM lparam);
  void OnTimer(WPARAM wparam, LPARAM lparam);
  void OnPaint(WPARAM wparam, LPARAM lparam);
  void OnSize(WPARAM wparam, LPARAM lparam);
  void OnSysCommand(WPARAM wparam, LPARAM lparam);
  void OnCommand(WPARAM wparam, LPARAM lparam);
  void OnDestroy(WPARAM wparam, LPARAM lparam);
  void OnLButtonDown(WPARAM wparam, LPARAM lparam);
  void OnLButtonUp(WPARAM wparam, LPARAM lparam);
  void OnMouseMove(WPARAM wparam, LPARAM lparam);
  void OnGetDlgCode(WPARAM wparam, LPARAM lparam);
  void OnKeyDown(WPARAM wparam, LPARAM lparam);
  int OnMouseWheel(WPARAM wparam, LPARAM lparam);
  void OnVScroll(WPARAM wparam, LPARAM lparam);

  HWND m_hwnd;

  WDL_PtrList<char> *m_fns;
  WDL_TypedBuf<int> *m_trk;

  HANDLE m_thread;
  bool m_kill_thread;
  WDL_Mutex m_mutex;
  int m_idx;

  WDL_VWnd m_images;
  WDL_VWnd_Painter m_painter;
};

#endif // _TERPSICHORE_PREVIEW_ARTWORK_WINDOW_H_
