// Copyright (c) 2017 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#include "terpsichore/settings.h"
#include "terpsichore/definitions.h"

static void free_str(const char *p)
{
  free ((void *)p);
}

RST_Settings::RST_Settings()
  : m_hwnd(NULL)
  , m_ini_file(g_ini_path.Get())
  , m_int_dict(true)
  , m_str_dict(true, free_str)
{}

RST_Settings::~RST_Settings()
{
  DeleteAll();
}

void RST_Settings::SetHandle(HWND hwnd, const char *section)
{
  m_hwnd = hwnd;
  m_section.Set(section);
}

void RST_Settings::Set(const char *what, int value)
{
  m_int_dict.Insert(what, value);
}

void RST_Settings::Set(const char *what, const char *value)
{
  m_str_dict.Insert(what, strdup(value));
}

bool RST_Settings::HasSettings() const
{
  return (m_str_dict.GetSize() > 0) ||
    (m_int_dict.GetSize() > 0);
}

void RST_Settings::Apply()
{
  const char *key;

  for (int i = 0; i < m_int_dict.GetSize(); i++)
  {
    m_int_dict.Enumerate(i, &key);
    m_ini_file.write_int(key, m_int_dict.Enumerate(i), m_section.Get());
  }

  for (int i = 0; i < m_str_dict.GetSize(); i++)
  {
    m_str_dict.Enumerate(i, &key);
    m_ini_file.write_str(key, m_str_dict.Enumerate(i), m_section.Get());
  }

  DeleteAll();
}

void RST_Settings::DeleteAll()
{
  m_int_dict.DeleteAll(true);
  m_str_dict.DeleteAll(true);
}
