// Copyright (c) 2017 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _TERPSICHORE_SETTINGS_H_
#define _TERPSICHORE_SETTINGS_H_

#include "terpsichore/definitions.h"
//#include "terpsichore/app_info.h"
#include "terpsichore/ini_file.h"

#include "WDL/wdlstring.h"
#include "WDL/assocarray.h"

class RST_Settings
{
public:
  RST_Settings();
  ~RST_Settings();

  void SetHandle(HWND hwnd, const char *section);

  void Set(const char *what, int value);

  void Set(const char *what, const char *value);

  bool HasSettings() const;

  void Apply();

  void DeleteAll();

private:
  HWND m_hwnd;

  WDL_FastString m_section;

  RST_IniFile m_ini_file;

  WDL_StringKeyedArray<int> m_int_dict;
  WDL_StringKeyedArray<const char *> m_str_dict;
};

#endif // _TERPSICHORE_SETTINGS_H_
