// Copyright (c) 2017 Giorgos Vougioukas
//
// The plug-in mechanism derived from REAPER plug-in API
// Copyright (c) 2006-2009, Cockos Incorporated
//
// This software is provided 'as-is', without any express or implied
// warranty.  In no event will the authors be held liable for any damages
// arising from the use of this software.
//
// Permission is granted to anyone to use this software for any purpose,
// including commercial applications, and to alter it and redistribute it
// freely, subject to the following restrictions:
//
//  1. The origin of this software must not be misrepresented; you must not
//     claim that you wrote the original software. If you use this software
//     in a product, an acknowledgment in the product documentation would be
//     appreciated but is not required.
//  2. Altered source versions must be plainly marked as such, and must not be
//     misrepresented as being the original software.
//  3. This notice may not be removed or altered from any source distribution.
//
//  Notes: the C++ interfaces used require MSVC on win32, or at least the
//  MSVC-compatible C++ ABI. Sorry, mingw users :(

#ifndef _TERPSICHORE_PLUGIN_H_
#define _TERPSICHORE_PLUGIN_H_

#include "terpsichore/terpsichore_plugin_public.h"

#include "terpsichore/sample_format.h"
#include "WDL/wdltypes.h"
#include "WDL/assocarray.h"

typedef int (*AudioCallback)(WDL_TypedBuf<SAM> *output, int frame_count, int nch);

class RST_IAudioStreamer
{
public:
  virtual ~RST_IAudioStreamer()
  {}

  virtual bool Open() = 0;
  virtual void Close() = 0;
  virtual void Start(AudioCallback callback) = 0;
  virtual void Stop() = 0;
  virtual bool IsRunning() const = 0;
  virtual double GetSampleRate() const = 0;
};

struct RST_AudioStreamerRegister
{
  RST_IAudioStreamer *(*CreateAudioStreamer)();
};

class RST_IAudioStreamerDevice
{
public:
  RST_IAudioStreamerDevice();
  virtual ~RST_IAudioStreamerDevice()
  {}

  virtual void Scan() = 0;

  virtual int GetDefaultInputDevice() const = 0;
  virtual int GetDefaultOutputDevice() const = 0;

  WDL_IntKeyedArray<const char *> input_dev;
  WDL_IntKeyedArray<const char *> output_dev;
};

struct RST_AudioStreamerDeviceRegister
{
  RST_IAudioStreamerDevice *(*CreateAudioStreamerDevice)();
};

class RST_IAudioStreamerProperties
{
public:
  virtual ~RST_IAudioStreamerProperties()
  {}

  virtual void PropertiesWindow(HWND parent, int rleft, int rtop) = 0;
};

struct RST_AudioStreamerPropertiesRegister
{
  RST_IAudioStreamerProperties *(*CreateAudioStreamerProperties)();
};

#endif // _TERPSICHORE_PLUGIN_H_
