// Copyright (c) 2021 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _TERPSICHORE_TRACK_H_
#define _TERPSICHORE_TRACK_H_

#include "terpsichore/terpsichore_plugin.h"
#include "terpsichore/buffer_queue.h"

#include "WDL/lice/lice.h"
#include "WDL/heapbuf.h"
#include "WDL/wdlstring.h"
#include "WDL/fileread.h"

class RST_Track
{
public:
  RST_Track();
  ~RST_Track();
  bool Open(const char *fn, int peakrate,
    WDL_StringKeyedArray<double> *ebur128_info);
  bool IsOpen();

  bool IsDrained() const;
  bool WantMore() const;
  bool DoBuffering(int buffer_size = 4096);
  double GetDuration() const;
  double GetRunTime() const;
  void UpdateRunTime(double time);
  void SeekBackward();
  void SeekForward();
  void Seek(double time);
  const char *GetTitle() const;
  const char *GetArtist() const;

  void Rewind(bool state);
  void FastForward(bool state);

  void DecreaseShift();
  void IncreaseShift();
  void DecreaseShiftSmall();
  void IncreaseShiftSmall();
  void DecreaseTempo();
  void IncreaseTempo();
  void DecreaseTempoSmall();
  void IncreaseTempoSmall();
  void ResetShift();
  void ResetTempo();
  double GetVolume() const;
  void SetVolume(double decibel);
  double GetFader() const;
  double GetFaderDecibel() const;
  void SetFader(double percentage);

  bool IsReverse() const;
  void ToggleReverse();

  LICE_IBitmap *GetWaveForm(HWND ctrl);
  int GetPeakRate() const { return m_peakrate; }

  RST_BufferQueue m_bq;
private:
  RST_IFileInput *m_fi;
  bool m_is_open;

  bool m_eof;

  int m_bq_max_duration;
  WDL_TypedBuf<SAM> m_buffer;

  double m_duration;
  double m_run_time;

  WDL_FastString m_title;
  WDL_FastString m_artist;

  RST_IPitchShift *m_ps;
  double m_shift;
  double m_tempo;
  double m_last_shift;
  double m_last_tempo;
  const double m_min_shift;
  const double m_max_shift;
  const double m_min_tempo;
  const double m_max_tempo;
  double m_shift_step;
  double m_tempo_step;
  double m_shift_altstep;
  double m_tempo_altstep;
  double m_seek_step;
  double m_volume;
  double m_fader;

  int m_ebur128normalization;
  int m_ebur128downwardonly;
  double m_ebur128reference;
  int m_ebur128mode;
  double m_ebur128momentary;
  double m_ebur128shortterm;
  int m_ebur128momentarywindow;
  int m_ebur128shorttermwindow;
  double m_ebur128integrated;
  double m_ebur128range;
  double m_ebur128samplepeak;
  double m_ebur128truepeak;
  double m_ebur128gain;

  bool m_rwd;
  bool m_fwd;
  bool m_prevrev;
  double m_prevshift;
  double m_prevtempo;

  LICE_IBitmap *m_wf;
  int m_peakrate;
  WDL_FileRead *m_pkfr;
};

#endif // _TERPSICHORE_TRACK_H_
