// Copyright (c) 2022 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#include "terpsichore/waveform_wnd.h"
#include "terpsichore/decks_wnd.h"

static LOGFONT lf =
{
#if defined(_WIN32)
  20, 0, 0, 0, FW_NORMAL, FALSE, FALSE, FALSE, DEFAULT_CHARSET,
  OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS, DEFAULT_QUALITY, DEFAULT_PITCH,
  "Arial"
#else
  17, 0, 0, 0, FW_NORMAL, FALSE, FALSE, FALSE, DEFAULT_CHARSET,
  OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS, DEFAULT_QUALITY, DEFAULT_PITCH,
  "Arial"
#endif
};

void RST_WaveformWnd::OnCreate(WPARAM wparam, LPARAM lparam)
{
  m_bm = new LICE_SysBitmap;

  RECT r;
  GetClientRect(m_hwnd, &r);
  m_bm->resize(r.right - r.left, r.bottom - r.top);
  InvalidateRect(m_hwnd, NULL, FALSE);
}

void RST_WaveformWnd::OnDestroy(WPARAM wparam, LPARAM lparam)
{
  delete m_bm;
}

void RST_WaveformWnd::OnPaint(WPARAM wparam, LPARAM lparam)
{
  PAINTSTRUCT ps;
  HDC dc = BeginPaint(m_hwnd, &ps);

  int w = m_bm->getWidth();
  int h = m_bm->getHeight();

  LICE_Clear(m_bm, LICE_RGBA(51, 51, 51, 255));

  RST_Deck *d = NULL;

  if (g_decka_wnd && g_decka_wnd->GetWaveFormControl() == m_hwnd)
  {
    d = g_main_loop->GetDeckA();
  }
  else if (g_deckb_wnd && g_deckb_wnd->GetWaveFormControl() == m_hwnd)
  {
    d = g_main_loop->GetDeckB();
  }

  if (d)
  {
    LICE_IBitmap *wf = d->track.GetWaveForm(m_hwnd);
    if (wf)
    {
      WDL_ASSERT(w == wf->getWidth());
      WDL_ASSERT(h == wf->getHeight());

      LICE_Blit(m_bm, wf, 0, 0, 0, 0, w / 2, h, 1.0f, LICE_BLIT_MODE_COPY);
      LICE_Blit(m_bm, wf, w / 2, 0, w / 2, 0, w / 2, h, 1.0f, LICE_BLIT_MODE_COPY);
    }
  }

  int r = 210; int g = 210; int b = 210;
  int len = 10; int wb = w - 1; int hb = h - 1;
  LICE_Line(m_bm, w / 2, 0, w / 2, h, LICE_RGBA(255, 0, 0, 255));
  LICE_Line(m_bm, 0, 0, len, 0, LICE_RGBA(r, g, b, 255));
  LICE_Line(m_bm, 0, 0, 0, len, LICE_RGBA(r, g, b, 255));
  LICE_Line(m_bm, wb - len, 0, wb, 0, LICE_RGBA(r, g, b, 255));
  LICE_Line(m_bm, wb, 0, wb, len, LICE_RGBA(r, g, b, 255));
  LICE_Line(m_bm, 0, hb - len, 0, hb, LICE_RGBA(r, g, b, 255));
  LICE_Line(m_bm, 0, hb, len, hb, LICE_RGBA(r, g, b, 255));
  LICE_Line(m_bm, wb, hb - len, wb, hb, LICE_RGBA(r, g, b, 255));
  LICE_Line(m_bm, wb - len, hb, wb, hb, LICE_RGBA(r, g, b, 255));
  BitBlt(dc, 0, 0, w, h, m_bm->getDC(), 0, 0, SRCCOPY);

  EndPaint(m_hwnd, &ps);
}

void RST_WaveformWnd::OnLButtonDown(WPARAM wparam, LPARAM lparam)
{}

void RST_WaveformWnd::OnLButtonUp(WPARAM wparam, LPARAM lparam)
{}

void RST_WaveformWnd::OnMouseMove(WPARAM wparam, LPARAM lparam)
{}

void RST_WaveformWnd::OnSize(WPARAM wparam, LPARAM lparam)
{
  RECT r;
  GetClientRect(m_hwnd, &r);
  m_bm->resize(r.right - r.left, r.bottom - r.top);
  InvalidateRect(m_hwnd, NULL, FALSE);
}

void RST_WaveformWnd::OnTimer(WPARAM wparam, LPARAM lparam)
{}

WDL_DLGRET RST_WaveformWnd::ST_WaveformWndProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam)
{
  RST_WaveformWnd *wf = (RST_WaveformWnd *)GetWindowLongPtr(hwnd, GWLP_USERDATA);

#if _WIN32
  if (!wf && msg == WM_NCCREATE)
#else
  if (!wf && msg == WM_CREATE)
#endif
  {
    wf = new RST_WaveformWnd(hwnd);
    SetWindowLongPtr(hwnd, GWLP_USERDATA, (INT_PTR)wf);
#ifndef _WIN32
    //SWELL_SetClassName(hwnd, "waveformb_superhost");
#endif
    if (wf) wf->OnCreate(wparam, lparam);
    return (wf != NULL);
  }

#if _WIN32
  if (wf && msg == WM_NCDESTROY)
#else
  if (wf && msg == WM_DESTROY)
#endif
  {
    wf->OnDestroy(wparam, lparam);
    delete wf; wf = NULL;
  }

  if (wf)
  {
    return wf->WaveformWndLoop(msg, wparam, lparam);
  }

  return 0;
}

WDL_DLGRET RST_WaveformWnd::WaveformWndLoop(UINT msg, WPARAM wparam, LPARAM lparam)
{
  switch (msg)
  {
#if _WIN32
    case WM_NCCREATE: OnCreate(wparam, lparam); break;
    case WM_NCDESTROY: OnDestroy(wparam, lparam); break;
#else
    case WM_CREATE: OnCreate(wparam, lparam); break;
    case WM_DESTROY: OnDestroy(wparam, lparam); break;
#endif
    case WM_PAINT: OnPaint(wparam, lparam); break;
    case WM_LBUTTONDOWN: OnLButtonDown(wparam, lparam); break;
    case WM_LBUTTONUP: OnLButtonUp(wparam, lparam); break;
    case WM_MOUSEMOVE: OnMouseMove(wparam, lparam); break;
    case WM_SIZE: OnSize(wparam, lparam); break;
    case WM_TIMER: OnTimer(wparam, lparam); break;
    //case WM_ERASEBKGND: return 1; break;
  }

  return DefWindowProc(m_hwnd, msg, wparam, lparam);
}
