// Copyright (c) 2022 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _TERPSICHORE_WAVEFORM_WND_H_
#define _TERPSICHORE_WAVEFORM_WND_H_

#include "terpsichore/definitions.h"

#include "WDL/wingui/wndsize.h"
#include "WDL/wdlstring.h"
#include "WDL/lice/lice.h"
#include "WDL/lice/lice_text.h"

class RST_WaveformWnd
{
public:
  RST_WaveformWnd(HWND hwnd)
    : m_hwnd(hwnd)
    , m_bm(NULL)
    , m_font(NULL)
  {
    //m_bgc = g_preferences->GetBackgroundColor();
    //m_txtc = g_preferences->GetTextColor();
  }

  ~RST_WaveformWnd()
  {
    if (m_font) delete m_font;
  }

  static WDL_DLGRET ST_WaveformWndProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam);
private:
  void OnCreate(WPARAM wparam, LPARAM lparam);
  void OnDestroy(WPARAM wparam, LPARAM lparam);
  void OnPaint(WPARAM wparam, LPARAM lparam);
  void OnLButtonDown(WPARAM wparam, LPARAM lparam);
  void OnLButtonUp(WPARAM wparam, LPARAM lparam);
  void OnMouseMove(WPARAM wparam, LPARAM lparam);
  void OnSize(WPARAM wparam, LPARAM lparam);
  void OnTimer(WPARAM wparam, LPARAM lparam);
  WDL_DLGRET WaveformWndLoop(UINT msg, WPARAM wparam, LPARAM lparam);

  HWND m_hwnd;
  LICE_IBitmap *m_bm;
  LICE_IFont *m_font;
  int m_bgc;
  int m_txtc;
};

#endif // _TERPSICHORE_WAVEFORM_WND_H_
