// Copyright (c) 2019 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _TERPSICHORE_AUDIO_STREAMER_PA_DIRECTSOUND_H_
#define _TERPSICHORE_AUDIO_STREAMER_PA_DIRECTSOUND_H_

#include <windows.h>

#include <portaudio.h>
#include <pa_win_ds.h>
#include <pa_util.h>

#include "terpsichore/terpsichore_plugin.h"
#include "terpsichore/ini_file.h"

#include "WDL/heapbuf.h"
#include "WDL/queue.h"
#include "WDL/wdlstring.h"

extern const char *(*GetSettingsPath)();

class RST_PaDirectSound : public RST_IAudioStreamer
{
public:
  RST_PaDirectSound();
  ~RST_PaDirectSound();

  bool Open();
  void Start(AudioCallback callback);
  void Stop();
  void Close();
  bool IsRunning() const;
  double GetSampleRate() const;

private:
  static int pa_callback(const void *input, void *output, unsigned long frame_count,
    const PaStreamCallbackTimeInfo *time_info, PaStreamCallbackFlags status_flags,
    void *user_data);

  RST_IniFile *m_ini_file;

  PaError m_error;
  PaStream *m_stream;
  bool m_running;

  AudioCallback m_callback;

  int m_sample_fmt;
  int m_samplerate;
  int m_output_nch;
  int m_output_dev;

  WDL_TypedBuf<SAM> m_buffer;
  WDL_HeapBuf m_pcm;
};

#endif // _TERPSICHORE_AUDIO_STREAMER_PA_DIRECTSOUND_H_
