// Copyright (c) 2020 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#include "terpsichore_ds/audio_streamer_pa_ds_prop.h"
#include "terpsichore_ds/res/resource.h"

RST_PaDirectSoundProperties::RST_PaDirectSoundProperties()
{}

RST_PaDirectSoundProperties::~RST_PaDirectSoundProperties()
{
  if (m_prop_wnd.Handle())
  {
    DestroyWindow(m_prop_wnd.Handle());
  }
}

void RST_PaDirectSoundProperties::PropertiesWindow(HWND parent, int rleft, int rtop)
{
  if (!m_prop_wnd.Handle())
  {
    CreateDialogParam(directsound_instance, MAKEINTRESOURCE(IDD_DIRECTSOUND),
      parent, RST_DirectSoundWnd::ST_DirectSoundWndProc, (LPARAM)&m_prop_wnd);

    SetWindowPos(m_prop_wnd.Handle(), NULL, rleft, rtop, 0, 0,
      SWP_NOACTIVATE | SWP_NOSIZE | SWP_NOZORDER);

    ShowWindow(m_prop_wnd.Handle(), SW_SHOW);
  }
  else
  {
    SetFocus(m_prop_wnd.Handle());
  }
}
