// Copyright (c) 2020 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#include "terpsichore/terpsichore_plugin.h"
#include "terpsichore_ds/audio_streamer_pa_ds.h"
#include "terpsichore_ds/audio_streamer_pa_ds_dev.h"
#include "terpsichore_ds/audio_streamer_pa_ds_prop.h"

#if defined(_WIN32) && defined(_DEBUG)
#include <vld.h>
#endif

#include "WDL/wdlcstring.h"

HINSTANCE directsound_instance;
static HWND directsound_main_hwnd;

double (*GetHardwareSampleRate)();
const char *(*GetSettingsPath)();

RST_IAudioStreamer *CreateAudioStreamer()
{
  return new RST_PaDirectSound;
}

RST_AudioStreamerRegister directsound_reg =
{
  &CreateAudioStreamer
};

RST_IAudioStreamerDevice *CreateAudioStreamerDevice()
{
  return new RST_PaDirectSoundDevice;
}

RST_AudioStreamerDeviceRegister directsound_dev_reg =
{
  &CreateAudioStreamerDevice
};

RST_IAudioStreamerProperties *CreateAudioStreamerProperties()
{
  return new RST_PaDirectSoundProperties;
}

RST_AudioStreamerPropertiesRegister directsound_prop_reg =
{
  &CreateAudioStreamerProperties
};

extern "C"
{
  TERPSICHORE_PLUGIN_EXPORT int TERPSICHORE_PLUGIN_ENTRYPOINT(
    TERPSICHORE_PLUGIN_HINSTANCE instance, RST_PluginInfo *rec)
  {
    directsound_instance = instance;

    if (rec)
    {
      if (rec->caller_version != TERPSICHORE_PLUGIN_VERSION || !rec->GetFunc)
      {
        return 0;
      }

      *((void **)&GetSettingsPath) = rec->GetFunc("GetClientSettingsPath");
      *((void **)&GetHardwareSampleRate) = rec->GetFunc("GetHardwareSampleRate");

      directsound_main_hwnd = rec->hwnd_main;

      if (!GetHardwareSampleRate || !GetSettingsPath || !rec->Register)
      {
        return 0;
      }

      rec->Register("audio_streamer:DirectSound", &directsound_reg);
      rec->Register("audio_device:DirectSound", &directsound_dev_reg);
      rec->Register("audio_properties:DirectSound", &directsound_prop_reg);

      return 1;
    }
    else
    {
      return 0;
    }
  }
}
