#include "terpsichore/terpsichore_plugin_public.h"
#include "terpsichore_gen/ffmpeg_input.h"
#include "terpsichore_gen/ffmpeg_tagger.h"
#include "terpsichore_gen/ffmpeg_pic.h"

#if defined(_WIN32) && defined(_DEBUG)
#include <vld.h>
#endif

//#define ENABLE_TERPSICHORE_INPUT_CONSOLE

#include "WDL/wdlcstring.h"

static HINSTANCE ffmpeg_instance;
static HWND ffmpeg_main_hwnd;

double (*GetHardwareSampleRate)();
int (*GetResamplerSinc)();
int (*GetDiskReadMode)();
int (*GetDiskReadBufferSize)();
int (*GetDiskReadBuffers)();

RST_IFileInput *CreateInputFromType(const char *type)
{
  if (!strcmp(type, "MP3"))
  {
    return new RST_FFmpegInput;
  }

  return NULL;
}

RST_IFileInput *CreateInputFromFile(const char *filename)
{
  if (!wdl_filename_cmp(WDL_get_fileext(filename), ".mp3") ||
    !wdl_filename_cmp(WDL_get_fileext(filename), ".flac"))
  //if (!wdl_filename_cmp(WDL_get_fileext(filename), ".mp3"))
  {
    RST_FFmpegInput *p = new RST_FFmpegInput;

    if (p->Open(filename))
    {
      return p;
    }

    delete p;
  }

  return NULL;
}

struct RST_AudioInputRegister ffmpeg_input_reg =
{
  CreateInputFromType,
  CreateInputFromFile,
};

RST_IFileTagger *CreateFFmpegTagger(const char *filename)
{
  if (!wdl_filename_cmp(WDL_get_fileext(filename), ".mp3") ||
    !wdl_filename_cmp(WDL_get_fileext(filename), ".flac"))
  {
    RST_FFmpegTagger *p = new RST_FFmpegTagger;

    if (p && p->Open(filename))
    {
      return p;
    }
    else
    {
      delete p;
    }
  }

  return NULL;
}

RST_FileTaggerRegister tagger_reg =
{
  &CreateFFmpegTagger
};

RST_IFilePic *CreateFFmpegPic(const char *filename)
{
  if (!wdl_filename_cmp(WDL_get_fileext(filename), ".mp3") ||
    !wdl_filename_cmp(WDL_get_fileext(filename), ".flac"))
  {
    RST_FFmpegPic *p = new RST_FFmpegPic();

    if (p->Open(filename))
    {
      return p;
    }
    else
    {
      delete p;
    }
  }

  return NULL;
}

RST_FilePicRegister apic_reg =
{
  &CreateFFmpegPic
};

void terpsichore_ffmpeg_log_callback(void *ptr, int level, const char *fmt, va_list vargs)
{
  vprintf(fmt, vargs);
}

extern "C"
{
  TERPSICHORE_PLUGIN_EXPORT int TERPSICHORE_PLUGIN_ENTRYPOINT(
    TERPSICHORE_PLUGIN_HINSTANCE instance, RST_PluginInfo *rec)
  {
#if defined(_WIN32) && defined(_DEBUG) && defined(ENABLE_TERPSICHORE_INPUT_CONSOLE)
    // The first will use the console only if
    // the application is started by the command 
    // line. The second one will always enable
    // the console.
    //if (AttachConsole(ATTACH_PARENT_PROCESS))
    if (AttachConsole(ATTACH_PARENT_PROCESS) || AllocConsole())
    {
        freopen("CONOUT$", "w", stdout);
        freopen("CONOUT$", "w", stderr);
    }

    // AV_LOG_QUIET
    // AV_LOG_PANIC
    // AV_LOG_FATAL
    // AV_LOG_ERROR
    // AV_LOG_WARNING
    // AV_LOG_INFO
    // AV_LOG_VERBOSE
    // AV_LOG_DEBUG
    av_log_set_level(AV_LOG_ERROR);
    av_log_set_callback(terpsichore_ffmpeg_log_callback);
#endif

    ffmpeg_instance = instance;

    if (rec)
    {
      if (rec->caller_version != TERPSICHORE_PLUGIN_VERSION || !rec->GetFunc)
      {
        return 0;
      }

      *((void **)&GetHardwareSampleRate) = rec->GetFunc("GetHardwareSampleRate");
      *((void **)&GetResamplerSinc) = rec->GetFunc("GetResamplerSinc");
      *((void **)&GetDiskReadMode) = rec->GetFunc("GetDiskReadMode");
      *((void **)&GetDiskReadBufferSize) = rec->GetFunc("GetDiskReadBufferSize");
      *((void **)&GetDiskReadBuffers) = rec->GetFunc("GetDiskReadBuffers");

      ffmpeg_main_hwnd = rec->hwnd_main;

      if (!GetHardwareSampleRate || !GetResamplerSinc || !rec->Register ||
        !GetDiskReadMode || !GetDiskReadBufferSize || !GetDiskReadBuffers)
      {
        return 0;
      }

      rec->Register("pcmsrc", &ffmpeg_input_reg);
      rec->Register("tagger", &tagger_reg);
      rec->Register("apic", &apic_reg);

      return 1;
    }
    else
    {
      return 0;
    }
  }
}
