#ifndef _TERPSICHORE_FFMPEG_FILE_PICTURE_H_
#define _TERPSICHORE_FFMPEG_FILE_PICTURE_H_

#include "terpsichore/terpsichore_plugin_public.h"
#include "terpsichore_gen/ffmpeg_input.h"

#include "WDL/heapbuf.h"
#include "WDL/fileread.h"

class RST_FFmpegPic : public RST_IFilePic
{
public:
  RST_FFmpegPic();
  ~RST_FFmpegPic();

  bool Open(const char *filename);

  int GetPicSize() const;
  void *GetPic() const;

private:
  void ReadPicture();
  bool FindCodec();
  CodecInfo m_codec_info;
  RST_FFmpegFileProtocol *m_protocol;
  RST_FFmpegGlue *m_glue;
  ScopedContext *m_context;

  bool m_eof;
  WDL_HeapBuf m_pic;
  WDL_FastString m_fn;
};

#endif // _TERPSICHORE_FFMPEG_FILE_PICTURE_H_
