#ifndef _TERPSICHORE_FFMPEG_TAGGER_H_
#define _TERPSICHORE_FFMPEG_TAGGER_H_

#include "terpsichore_gen/ffmpeg_glue.h"
#include "terpsichore_gen/ffmpeg_input.h"
#include "terpsichore/terpsichore_plugin_public.h"

#include "WDL/wdlstring.h"

class RST_FFmpegTagger : public RST_IFileTagger
{
public:
  RST_FFmpegTagger();
  ~RST_FFmpegTagger();

  bool Open(const char *filename);

  const char *GetType() const;

  const char *GetTitle() const;
  const char *GetArtist() const;
  const char *GetAlbum() const;
  const char *GetGenre() const;
  int GetTrack() const;
  int GetYear() const;
  const char *GetComment() const;

  int GetBitRate() const;
  double GetSampleRate() const;
  int GetChannels() const;
  double GetLength() const;
  WDL_INT64 GetFileSize() const;
  const char *GetFileName() const;
  const char *GetFilePath() const;
  const char *GetFileExtension() const;
  const char *GetSHA() const;

private:
  bool FindCodec();
  int SizeOfFormat(int fmt);

  RST_FFmpegFileProtocol *m_protocol;
  RST_FFmpegGlue *m_glue;
  CodecInfo m_codec_info;

  WDL_FastString m_fn;
  WDL_FastString m_fn_part;
  WDL_FastString m_fn_ext;
  WDL_String m_fn_type;
  WDL_FastString m_sha;

  WDL_FastString m_title;
  WDL_FastString m_artist;
  WDL_FastString m_album;
  WDL_FastString m_genre;
  int m_track;
  int m_year;
  WDL_FastString m_comment;

  int m_bitrate;
  double m_samplerate;
  int m_channels;
  double m_length;
  WDL_INT64 m_file_size;
};

#endif // _TERPSICHORE_FFMPEG_TAGGER_H_
